/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import java.util.List;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

public class FloatParameterFilter
extends ParameterFilter {
    List<Float> values;
    Float threshold;

    public String apply(String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return "";
        }
        float val = Float.parseFloat(str);
        float best = Float.MIN_VALUE;
        float bestMismatch = Float.MAX_VALUE;
        for (Float fl : this.values) {
            float mismatch = Math.abs(fl.floatValue() - val);
            if (!(mismatch < bestMismatch)) continue;
            best = fl.floatValue();
            bestMismatch = mismatch;
        }
        if (this.threshold != null && this.threshold.floatValue() > 0.0f && Math.abs(bestMismatch) < this.threshold.floatValue()) {
            return Float.toString(best);
        }
        throw new ParameterException("Closest match for " + this.key + "=" + str + " is " + Float.toString(best) + ", but this exceeds the threshold of " + Float.toString(this.threshold.floatValue()));
    }
}

