/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;

public class BlankTileException
extends RequestFilterException {
    private static Log log = LogFactory.getLog(BlankTileException.class);
    private static volatile byte[] blankTile;

    public BlankTileException(RequestFilter reqFilter) {
        super(reqFilter, 200, "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBlankTile() {
        byte[] blankTile = new byte[425];
        InputStream is = null;
        try {
            is = GeoWebCacheDispatcher.class.getResourceAsStream("blank.png");
            blankTile = new byte[425];
            int ret = is.read(blankTile);
            log.info((Object)("Read " + ret + " from blank PNG file (expected 425)."));
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return blankTile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getResponse() {
        byte[] ret = blankTile;
        if (ret != null) return ret;
        Class<BlankTileException> clazz = BlankTileException.class;
        synchronized (BlankTileException.class) {
            ret = blankTile;
            if (ret != null) return ret;
            blankTile = ret = this.getBlankTile();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }
}

