/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.BlankTileException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;

public class CircularExtentFilter
extends RequestFilter {
    CircularExtentFilter() {
    }

    public void apply(ConveyorTile convTile) throws RequestFilterException {
        TileLayer tl = convTile.getLayer();
        SRS srs = convTile.getSRS();
        Grid grid = tl.getGrid(srs);
        int z = convTile.getTileIndex()[2];
        int[] gridBounds = null;
        try {
            gridBounds = grid.getGridCalculator().getGridBounds(z);
        }
        catch (GeoWebCacheException e) {
            e.printStackTrace();
        }
        int width = gridBounds[2] - gridBounds[0];
        int height = gridBounds[3] - gridBounds[1];
        int maxRad = 0;
        maxRad = width > height ? width / 4 + 1 : height / 4 + 1;
        int midX = gridBounds[0] + width / 2;
        int midY = gridBounds[1] + height / 2;
        int xDist = midX - convTile.getTileIndex()[0];
        int yDist = midY - convTile.getTileIndex()[1];
        long rad = Math.round(Math.sqrt(xDist * xDist + yDist * yDist));
        if (rad > (long)maxRad) {
            throw new BlankTileException(this);
        }
    }

    public void initialize(TileLayer layer) throws GeoWebCacheException {
    }

    public boolean update(TileLayer layer, SRS srs) {
        return false;
    }

    public void update(TileLayer layer, SRS srs, int zoomStart, int zoomStop) throws GeoWebCacheException {
    }

    public void update(byte[] filterData, TileLayer layer, SRS srs, int z) throws GeoWebCacheException {
    }
}

