/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.GridCalculator;
import org.geowebcache.layer.SRS;
import org.geowebcache.util.wms.BBOX;

public class Grid {
    private static Log log = LogFactory.getLog(Grid.class);
    private SRS srs = null;
    protected BBOX dataBounds = null;
    protected BBOX gridBounds = null;
    protected int zoomStart;
    protected int zoomStop;
    protected double[] resolutions = null;
    private transient boolean staticResolutions = false;
    private volatile transient GridCalculator gridCalculator;

    public Grid(SRS srs, BBOX bounds, BBOX gridBounds, double[] resolutions) {
        this.srs = srs;
        this.dataBounds = bounds;
        this.gridBounds = gridBounds;
        this.resolutions = resolutions;
    }

    public void setBounds(BBOX bounds) {
        this.dataBounds = bounds;
    }

    public void setBounds(String bounds) {
        this.dataBounds = new BBOX(bounds);
    }

    public void setGridBounds(BBOX gridbounds) {
        this.gridBounds = gridbounds;
    }

    public void setGridBounds(String gridbounds) {
        this.gridBounds = new BBOX(gridbounds);
    }

    public void setSRS(SRS srs) {
        this.srs = srs;
    }

    public SRS getSRS() {
        return this.srs;
    }

    public BBOX getBounds() {
        return this.dataBounds;
    }

    public BBOX getGridBounds() {
        return this.gridBounds;
    }

    public int getZoomStart() {
        return this.zoomStart;
    }

    public int getZoomStop() {
        return this.zoomStop;
    }

    public boolean hasStaticResolutions() {
        return this.staticResolutions;
    }

    public double[] getResolutions() throws GeoWebCacheException {
        return this.getGridCalculator().getResolutions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCalculator getGridCalculator() throws GeoWebCacheException {
        GridCalculator ret = this.gridCalculator;
        if (ret == null) {
            Grid grid = this;
            synchronized (grid) {
                ret = this.gridCalculator;
                if (this.gridCalculator == null) {
                    this.gridCalculator = ret = this.initGridCalculator();
                }
            }
        }
        return ret;
    }

    private GridCalculator initGridCalculator() throws GeoWebCacheException {
        if (this.resolutions != null) {
            this.staticResolutions = true;
            this.zoomStart = 0;
            this.zoomStop = this.resolutions.length - 1;
        } else if (this.zoomStart < 0 || this.zoomStop < this.zoomStart || this.zoomStop == 0) {
            log.debug((Object)"Missing values, setting zoomStart,zoomStop to 0,30");
            this.zoomStart = 0;
            this.zoomStop = 30;
        }
        GridCalculator gridCalc = new GridCalculator(this);
        return gridCalc;
    }
}

