/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.OutOfBoundsException;
import org.geowebcache.util.wms.BBOX;

public class GridCalculator {
    private static Log log = LogFactory.getLog(GridCalculator.class);
    public static final int TILEPIXELS = 256;
    public static final double RESOLUTION_TOLERANCE = 0.05;
    private Grid grid;
    private static final double[] RESOLUTIONS4326 = GridCalculator.getResolutionArray(180.0, 256.0, 31);
    private static final double[] RESOLUTIONS900913 = GridCalculator.getResolutionArray(4.007501668E7, 256.0, 31);
    private double gridWidth;
    private double gridHeight;
    private int gridX = -1;
    private int gridY = -1;
    private double[] resolutions;
    private int zoomStart;
    private int zoomStop;
    private int[] zoomedOutGridLoc = null;
    private int[][] boundsGridLevels = null;

    public GridCalculator(Grid grid) throws GeoWebCacheException {
        this.grid = grid;
        if (grid.hasStaticResolutions()) {
            this.resolutions = new double[grid.resolutions.length];
            System.arraycopy(grid.resolutions, 0, this.resolutions, 0, this.resolutions.length);
            this.zoomStop = this.resolutions.length - 1;
        } else {
            this.zoomStart = grid.getZoomStart();
            this.zoomStop = grid.getZoomStop();
        }
        BBOX gridBounds = grid.gridBounds;
        this.gridWidth = gridBounds.coords[2] - gridBounds.coords[0];
        this.gridHeight = gridBounds.coords[3] - gridBounds.coords[1];
        this.determineGrid();
        this.boundsGridLevels = this.calculateGridBounds(grid.dataBounds);
    }

    private void determineGrid() throws GeoWebCacheException {
        if (!this.grid.hasStaticResolutions()) {
            double ratio = this.gridWidth / this.gridHeight;
            if (Math.abs(ratio - 1.0) < 0.025) {
                this.gridX = 1;
                this.gridY = 1;
            }
            if (ratio > 1.0) {
                if (Math.abs(ratio - (double)Math.round(ratio)) < 0.025) {
                    this.gridY = 1;
                    this.gridX = (int)Math.round(ratio);
                } else {
                    this.gridY = 1;
                    this.gridX = 1;
                    this.gridHeight = this.gridWidth;
                }
                this.determineResolutions();
            } else {
                ratio = this.gridHeight / this.gridWidth;
                if (Math.abs(ratio - (double)Math.round(ratio)) < 0.025) {
                    this.gridY = (int)Math.round(ratio);
                    this.gridX = 1;
                } else {
                    this.gridY = 1;
                    this.gridX = 1;
                    this.gridWidth = this.gridHeight;
                }
                this.determineResolutions();
            }
        } else {
            double denominator = this.resolutions[0] * 256.0;
            this.gridX = (int)Math.round(this.gridWidth / denominator);
            this.gridY = (int)Math.round(this.gridHeight / denominator);
        }
    }

    private void determineResolutions() throws GeoWebCacheException {
        double baseResolution;
        if (this.gridY == 1) {
            baseResolution = this.gridHeight / 256.0;
        } else if (this.gridX == 1) {
            baseResolution = this.gridWidth / 256.0;
        } else {
            throw new GeoWebCacheException("Unable to find height or width to calculate resolution array.");
        }
        this.resolutions = new double[this.zoomStop + 1];
        for (int i = 0; i <= this.zoomStop; ++i) {
            this.resolutions[i] = baseResolution;
            baseResolution /= 2.0;
        }
    }

    private int[][] calculateGridBounds(BBOX layerBounds) {
        BBOX gridBounds = this.grid.gridBounds;
        int[][] gridLevels = new int[this.zoomStop + 1][4];
        double[] rawNumber = new double[4];
        for (int level = 0; level <= this.zoomStop; ++level) {
            double tileDelta = this.resolutions[level] * 256.0;
            rawNumber[0] = (layerBounds.coords[0] - gridBounds.coords[0]) / tileDelta;
            gridLevels[level][0] = (int)Math.floor(rawNumber[0]);
            rawNumber[1] = (layerBounds.coords[1] - gridBounds.coords[1]) / tileDelta;
            gridLevels[level][1] = (int)Math.floor(rawNumber[1]);
            rawNumber[2] = (layerBounds.coords[2] - gridBounds.coords[0] - 1.0E-5) / tileDelta;
            gridLevels[level][2] = (int)Math.floor(rawNumber[2]);
            rawNumber[3] = (layerBounds.coords[3] - gridBounds.coords[1] - 1.0E-5) / tileDelta;
            gridLevels[level][3] = (int)Math.floor(rawNumber[3]);
        }
        return gridLevels;
    }

    public int[] getGridBounds(int zoomLevel) {
        return (int[])this.boundsGridLevels[zoomLevel].clone();
    }

    public int[][] getGridBounds() {
        int[][] ret = new int[this.boundsGridLevels.length][this.boundsGridLevels[0].length];
        for (int i = 0; i < this.boundsGridLevels.length; ++i) {
            ret[i] = (int[])this.boundsGridLevels[i].clone();
        }
        return ret;
    }

    public int[] gridLocation(BBOX tileBounds) throws BadTileException {
        int[] retVals = new int[3];
        double reqTileWidth = tileBounds.coords[2] - tileBounds.coords[0];
        retVals[2] = this.linearSearchForResolution(reqTileWidth / 256.0);
        if (retVals[2] < this.zoomStart) {
            throw new BadTileException("zoomStart is " + this.zoomStart + " but tile would be " + retVals[2]);
        }
        double tileWidth = this.resolutions[retVals[2]] * 256.0;
        BBOX gridBounds = this.grid.gridBounds;
        double xdiff = tileBounds.coords[0] - gridBounds.coords[0];
        double xLoc = xdiff / tileWidth;
        retVals[0] = (int)Math.round(xLoc);
        double absdiff = Math.abs((double)retVals[0] * tileWidth - xdiff);
        if (absdiff > 5.0E-5 && absdiff / tileWidth > 0.05) {
            throw new BadTileException("Your bounds in the x direction are offset by more than 5% compared to the underlying grid.\n Given " + tileBounds.coords[0] + " the closest match is index " + retVals[0] + ", which corresponds to " + ((double)retVals[0] * tileWidth + gridBounds.coords[0]));
        }
        double ydiff = tileBounds.coords[1] - gridBounds.coords[1];
        double yLoc = ydiff / tileWidth;
        retVals[1] = (int)Math.round(yLoc);
        absdiff = Math.abs((double)retVals[1] * tileWidth - ydiff);
        if (absdiff > 5.0E-5 && absdiff / tileWidth > 0.05) {
            throw new BadTileException("Your bounds in the y direction are offset by more than 5% compared to the underlying grid.\n Given " + tileBounds.coords[1] + " the closest match is index " + retVals[1] + ", which corresponds to " + ((double)retVals[1] * tileWidth + gridBounds.coords[1]));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("x: " + retVals[0] + "  y: " + retVals[1] + "  z: " + retVals[2]));
        }
        return retVals;
    }

    public void locationWithinBounds(int[] location) throws OutOfBoundsException {
        if (location[2] < this.zoomStart) {
            throw new OutOfBoundsException("zoomlevel (" + location[2] + ") can be at least " + this.zoomStart);
        }
        if (location[2] >= this.boundsGridLevels.length) {
            throw new OutOfBoundsException("zoomlevel (" + location[2] + ") can be at most " + this.boundsGridLevels.length);
        }
        int[] bounds = this.boundsGridLevels[location[2]];
        if (location[0] < bounds[0]) {
            throw new OutOfBoundsException("gridX (" + location[0] + ") must be at least " + bounds[0]);
        }
        if (location[0] > bounds[2]) {
            throw new OutOfBoundsException("gridX (" + location[0] + ") can be at most " + bounds[2]);
        }
        if (location[1] < bounds[1]) {
            throw new OutOfBoundsException("gridY (" + location[1] + ") must be at least " + bounds[1]);
        }
        if (location[1] > bounds[3]) {
            throw new OutOfBoundsException("gridY (" + location[1] + ") can be at most " + bounds[3]);
        }
    }

    public BBOX bboxFromGridLocation(int[] gridLoc) {
        double tileWidth = this.resolutions[gridLoc[2]] * 256.0;
        BBOX gridBounds = this.grid.gridBounds;
        return new BBOX(gridBounds.coords[0] + tileWidth * (double)gridLoc[0], gridBounds.coords[1] + tileWidth * (double)gridLoc[1], gridBounds.coords[0] + tileWidth * (double)(gridLoc[0] + 1), gridBounds.coords[1] + tileWidth * (double)(gridLoc[1] + 1));
    }

    public BBOX bboxFromGridBounds(int[] gridLocBounds) {
        double tileWidth = 256.0 * this.resolutions[gridLocBounds[4]];
        BBOX gridBounds = this.grid.gridBounds;
        return new BBOX(gridBounds.coords[0] + tileWidth * (double)gridLocBounds[0], gridBounds.coords[1] + tileWidth * (double)gridLocBounds[1], gridBounds.coords[0] + tileWidth * (double)(gridLocBounds[2] + 1), gridBounds.coords[1] + tileWidth * (double)(gridLocBounds[3] + 1));
    }

    public int[][] coveredGridLevels(BBOX requestedBounds) {
        return this.calculateGridBounds(requestedBounds);
    }

    public int[][] getZoomInGridLoc(int[] gridLoc) {
        int[][] retVal = new int[4][3];
        int x = gridLoc[0] * 2;
        int y = gridLoc[1] * 2;
        int z = gridLoc[2] + 1;
        if (z > this.zoomStop) {
            z = -1;
        }
        int n = x;
        retVal[2][0] = n;
        retVal[0][0] = n;
        int n2 = x + 1;
        retVal[3][0] = n2;
        retVal[1][0] = n2;
        int n3 = y;
        retVal[1][1] = n3;
        retVal[0][1] = n3;
        int n4 = y + 1;
        retVal[3][1] = n4;
        retVal[2][1] = n4;
        int n5 = z;
        retVal[3][2] = n5;
        retVal[2][2] = n5;
        retVal[1][2] = n5;
        retVal[0][2] = n5;
        if (z < 0) {
            return retVal;
        }
        int[] bounds = this.boundsGridLevels[z];
        for (int i = 0; i < 4; ++i) {
            if (retVal[i][0] >= bounds[0] && retVal[i][1] >= bounds[1] && retVal[i][0] <= bounds[2] && retVal[i][1] <= bounds[3]) continue;
            retVal[i][2] = -1;
        }
        return retVal;
    }

    public int[] getZoomedOutGridLoc() {
        int i;
        if (this.zoomedOutGridLoc != null) {
            return this.zoomedOutGridLoc;
        }
        if (this.gridX == 2 && this.gridY == 1 && this.boundsGridLevels[0][0] != this.boundsGridLevels[0][2]) {
            this.zoomedOutGridLoc = new int[3];
            this.zoomedOutGridLoc[0] = -1;
            this.zoomedOutGridLoc[1] = -1;
            this.zoomedOutGridLoc[2] = -1;
            return this.zoomedOutGridLoc;
        }
        for (i = this.boundsGridLevels.length - 1; i > 0 && (this.boundsGridLevels[i][0] != this.boundsGridLevels[i][2] || this.boundsGridLevels[i][1] != this.boundsGridLevels[i][3]); --i) {
        }
        this.zoomedOutGridLoc = new int[3];
        this.zoomedOutGridLoc[0] = this.boundsGridLevels[i][0];
        this.zoomedOutGridLoc[1] = this.boundsGridLevels[i][1];
        this.zoomedOutGridLoc[2] = i;
        return this.zoomedOutGridLoc;
    }

    public double[] getResolutions() {
        return this.resolutions;
    }

    private int linearSearchForResolution(double reqResolution) throws BadTileException {
        return GridCalculator.linearSearchForResolution(this.resolutions, reqResolution);
    }

    protected static int linearSearchForResolution(double[] resolutions, double reqResolution) throws BadTileException {
        int iBelow;
        int maxIndex = resolutions.length - 1;
        double minResolution = resolutions[maxIndex] * 0.95;
        if (reqResolution < minResolution) {
            throw new BadTileException("Resolution (" + reqResolution + ") is too small for the grid. " + "Minimum allowed value is " + minResolution);
        }
        double maxResolution = resolutions[0] * 1.05;
        if (reqResolution > maxResolution) {
            throw new BadTileException("Resolution (" + reqResolution + ") is too big for the grid. " + "Maximum allowed value is " + maxResolution);
        }
        if (reqResolution <= resolutions[maxIndex]) {
            return maxIndex;
        }
        if (reqResolution >= resolutions[0]) {
            return 0;
        }
        for (iBelow = 1; iBelow < resolutions.length && !(resolutions[iBelow] < reqResolution); ++iBelow) {
        }
        double gridBelow = resolutions[iBelow];
        double gridAbove = resolutions[iBelow - 1];
        int closestIndex = reqResolution - gridBelow < gridAbove - reqResolution ? iBelow : iBelow - 1;
        double gridResolution = resolutions[closestIndex];
        double tol = gridResolution * 0.05;
        if (reqResolution >= gridResolution - tol && reqResolution <= gridResolution + tol) {
            return closestIndex;
        }
        throw new BadTileException("Resolution (" + reqResolution + ") is not with " + 5.0 + "% of the closest grid resolution (" + gridResolution + ")");
    }

    public static double[] getResolutionArray(double width, double pixelWidth, int levels) {
        double[] resolutionArray = new double[levels];
        double resolution = width / pixelWidth;
        for (int i = 0; i < levels; ++i) {
            resolutionArray[i] = resolution;
            resolution /= 2.0;
        }
        return resolutionArray;
    }

    public static int[][] expandBoundsToMetaTiles(int[][] gridBounds, int[][] reqBounds, int[] meta) {
        int[][] ret = new int[reqBounds.length][reqBounds[0].length];
        for (int i = 0; i < reqBounds.length; ++i) {
            ret[i][0] = reqBounds[i][0] - reqBounds[i][0] % meta[0];
            ret[i][1] = reqBounds[i][1] - reqBounds[i][1] % meta[1];
            ret[i][2] = reqBounds[i][2] - reqBounds[i][2] % meta[0] + meta[0] - 1;
            ret[i][3] = reqBounds[i][3] - reqBounds[i][3] % meta[1] + meta[1] - 1;
        }
        return ret;
    }

    public static double[] get900913Resolutions() {
        return RESOLUTIONS900913;
    }

    public static double[] get4326Resolutions() {
        return RESOLUTIONS4326;
    }
}

