/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.GridCalculator;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRangeObject;

public class TruncateTask
extends GWCTask {
    private static Log log = LogFactory.getLog(TruncateTask.class);
    private final SeedRequest req;
    private final TileLayer tl;
    private final StorageBroker storageBroker;
    private static final double[] nullBbox = new double[]{0.0, 0.0, 0.0, 0.0};

    public TruncateTask(StorageBroker sb, SeedRequest req, TileLayer tl) {
        this.storageBroker = sb;
        this.req = req;
        this.tl = tl;
        this.type = 2;
        this.layerName = tl.getName();
    }

    public void doAction() throws GeoWebCacheException {
        this.tl.isInitialized();
        this.runFilterUpdates();
        int[][] bounds = null;
        if (this.req.getBounds() == null) {
            bounds = this.tl.getCoveredGridLevels(this.req.getSRS(), this.tl.getGrid(this.req.getSRS()).getBounds());
        } else if (!Arrays.equals(this.req.getBounds().coords, nullBbox)) {
            bounds = this.tl.getCoveredGridLevels(this.req.getSRS(), this.req.getBounds());
        }
        MimeType mimeType = MimeType.createFromFormat(this.req.getMimeFormat());
        if (bounds != null) {
            int[] metaFactors = this.tl.getMetaTilingFactors();
            int[][] gridBounds = this.tl.getGrid(this.req.getSRS()).getGridCalculator().getGridBounds();
            if (metaFactors[0] > 1 || metaFactors[1] > 1 && mimeType.supportsTiling()) {
                bounds = GridCalculator.expandBoundsToMetaTiles(gridBounds, bounds, metaFactors);
            }
        }
        TileRangeObject trObj = new TileRangeObject(this.layerName, this.req.getSRS(), this.req.getZoomStart(), this.req.getZoomStop(), bounds, mimeType, this.req.getParameters());
        try {
            this.storageBroker.delete(trObj);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        log.info((Object)"Completed truncate request.");
    }

    private void runFilterUpdates() {
        List<RequestFilter> reqFilters;
        if ((this.req.getFilterUpdate() == null || this.req.getFilterUpdate().booleanValue()) && (reqFilters = this.tl.getRequestFilters()) != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, this.req.getSRS())) {
                    log.info((Object)("Updated request filter " + reqFilter.getName()));
                    continue;
                }
                log.debug((Object)("Request filter " + reqFilter.getName() + " returned false on update."));
            }
        }
    }
}

