/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.kml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.GreenTileException;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.ServiceException;
import org.geowebcache.storage.StorageBroker;

public class KMZHelper {
    private static Log log = LogFactory.getLog(KMZHelper.class);

    public static int[][] filterGridLocs(StorageBroker sb, TileLayer tileLayer, MimeType mime, int[][] linkGridLocs) throws GeoWebCacheException {
        for (int i = 0; i < linkGridLocs.length; ++i) {
            if (linkGridLocs[i][2] <= 0) continue;
            ConveyorTile tile = new ConveyorTile(sb, tileLayer.getName(), SRS.getEPSG4326(), linkGridLocs[i], mime, null, null, null, null);
            tile.setTileLayer(tileLayer);
            try {
                tileLayer.applyRequestFilters(tile);
            }
            catch (GreenTileException e) {
            }
            catch (RequestFilterException e) {
                linkGridLocs[i][2] = -1;
                continue;
            }
            if (!mime.equals(XMLMime.kml)) continue;
            try {
                tileLayer.getTile(tile);
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage());
                linkGridLocs[i][2] = -1;
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                gwce.printStackTrace();
                linkGridLocs[i][2] = -1;
            }
            if (tile.getStatus() == 204) {
                linkGridLocs[i][2] = -1;
                continue;
            }
            if (tile.getStatus() == 200) continue;
            throw new GeoWebCacheException("Unexpected response code from server " + tile.getStatus());
        }
        return linkGridLocs;
    }

    protected static byte[] createZippedKML(String namePfx, String formatExtension, byte[] overlayXml, byte[] dataXml) throws ServiceException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            KMZHelper.writeZippedKML(namePfx, formatExtension, overlayXml, dataXml, out);
        }
        catch (IOException ioe) {
            throw new ServiceException("Encountered problem writing zip: " + ioe.getMessage());
        }
        return out.toByteArray();
    }

    private static void writeZippedKML(String namePfx, String formatExtension, byte[] overlay, byte[] data, OutputStream out) throws IOException {
        ZipOutputStream zipos = new ZipOutputStream(out);
        ZipEntry zeOl = new ZipEntry("netlinks_" + namePfx + ".kml");
        zipos.putNextEntry(zeOl);
        zipos.write(overlay);
        if (data != null) {
            ZipEntry zeData = new ZipEntry("data_" + namePfx + "." + formatExtension);
            zipos.putNextEntry(zeData);
            zipos.write(data);
        }
        zipos.finish();
    }
}

