/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.wms.BBOX;

public class WMSGetCapabilities {
    private static Log log = LogFactory.getLog(WMSGetCapabilities.class);
    private TileLayerDispatcher tld;
    private String urlStr;
    private boolean renderTileSets = false;

    protected WMSGetCapabilities(TileLayerDispatcher tld, HttpServletRequest servReq) {
        this.tld = tld;
        this.urlStr = servReq.getRequestURL().toString() + "?SERVICE=WMS&amp;";
        String tiledStr = servReq.getParameter("tiled");
        if (tiledStr != null && tiledStr.equalsIgnoreCase("true")) {
            this.renderTileSets = true;
        }
    }

    protected void writeReponse(HttpServletResponse response) {
        byte[] data = this.generateGetCapabilities().getBytes();
        response.setStatus(200);
        response.setContentType("application/vnd.ogc.wms_xml");
        response.setContentLength(data.length);
        try {
            ServletOutputStream os = response.getOutputStream();
            os.write(data);
            os.flush();
        }
        catch (IOException ioe) {
            log.debug((Object)("Caught IOException" + ioe.getMessage()));
        }
    }

    private String generateGetCapabilities() {
        StringBuilder str = new StringBuilder();
        str.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        str.append("<!DOCTYPE WMT_MS_Capabilities SYSTEM \"http://schemas.opengis.net/wms/1.1.1/capabilities_1_1_1.dtd\">\n");
        str.append("<WMT_MS_Capabilities version=\"1.1.1\">\n");
        this.service(str);
        this.capability(str);
        str.append("</WMT_MS_Capabilities>\n");
        return str.toString();
    }

    private void service(StringBuilder str) {
        str.append("<Service>\n");
        str.append("  <Name>OGC:WMS</Name>\n");
        str.append("  <Title>GeoWebCache</Title>\n");
        str.append("  <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.urlStr + "\"/>\n");
        str.append("</Service>\n");
    }

    private void capability(StringBuilder str) {
        str.append("<Capability>\n");
        str.append("  <Request>\n");
        this.capabilityRequestGetCapabilities(str);
        this.capabilityRequestGetMap(str);
        this.capabilityRequestGetFeatureInfo(str);
        this.capabilityRequestDescribeLayer(str);
        this.capabilityRequestGetLegendGraphic(str);
        str.append("  </Request>\n");
        this.capabilityException(str);
        this.capabilityVendorSpecific(str);
        this.capabilityLayerOuter(str);
        str.append("</Capability>\n");
    }

    private void capabilityRequestGetCapabilities(StringBuilder str) {
        str.append("    <GetCapabilities>\n");
        str.append("      <Format>application/vnd.ogc.wms_xml</Format>\n");
        str.append("      <DCPType>\n");
        str.append("        <HTTP>\n");
        str.append("          <Get>\n");
        str.append("            <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.urlStr + "\"/>\n");
        str.append("          </Get>\n");
        str.append("        </HTTP>\n");
        str.append("      </DCPType>\n");
        str.append("    </GetCapabilities>\n");
    }

    private void capabilityRequestGetMap(StringBuilder str) {
        Iterator<TileLayer> layerIter = this.tld.getLayers().values().iterator();
        HashSet<String> formats = new HashSet<String>();
        while (layerIter.hasNext()) {
            TileLayer layer = layerIter.next();
            if (layer.getMimeTypes() != null) {
                for (MimeType mime : layer.getMimeTypes()) {
                    formats.add(mime.getFormat());
                }
                continue;
            }
            formats.add("image/png");
            formats.add("image/jpeg");
        }
        str.append("    <GetMap>\n");
        Iterator formatIter = formats.iterator();
        while (formatIter.hasNext()) {
            str.append("      <Format>" + (String)formatIter.next() + "</Format>\n");
        }
        str.append("      <DCPType>\n");
        str.append("        <HTTP>\n");
        str.append("          <Get>\n");
        str.append("            <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.urlStr + "\"/>\n");
        str.append("          </Get>\n");
        str.append("        </HTTP>\n");
        str.append("      </DCPType>\n");
        str.append("    </GetMap>\n");
    }

    private void capabilityRequestGetFeatureInfo(StringBuilder str) {
        str.append("    <GetFeatureInfo>\n");
        str.append("      <Format>text/plain</Format>\n");
        str.append("      <Format>text/html</Format>\n");
        str.append("      <Format>application/vnd.ogc.gml</Format>\n");
        str.append("      <DCPType>\n");
        str.append("        <HTTP>\n");
        str.append("          <Get>\n");
        str.append("            <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.urlStr + "\"/>\n");
        str.append("          </Get>\n");
        str.append("        </HTTP>\n");
        str.append("      </DCPType>\n");
        str.append("    </GetFeatureInfo>\n");
    }

    private void capabilityRequestDescribeLayer(StringBuilder str) {
        str.append("    <DescribeLayer>\n");
        str.append("      <Format>application/vnd.ogc.wms_xml</Format>\n");
        str.append("      <DCPType>\n");
        str.append("        <HTTP>\n");
        str.append("          <Get>\n");
        str.append("            <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.urlStr + "\"/>\n");
        str.append("          </Get>\n");
        str.append("        </HTTP>\n");
        str.append("      </DCPType>\n");
        str.append("    </DescribeLayer>\n");
    }

    private void capabilityRequestGetLegendGraphic(StringBuilder str) {
        str.append("    <GetLegendGraphic>\n");
        str.append("      <Format>image/png</Format>\n");
        str.append("      <Format>image/jpeg</Format>\n");
        str.append("      <Format>image/gif</Format>\n");
        str.append("      <DCPType>\n");
        str.append("        <HTTP>\n");
        str.append("          <Get>\n");
        str.append("            <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.urlStr + "\"/>\n");
        str.append("          </Get>\n");
        str.append("        </HTTP>\n");
        str.append("      </DCPType>\n");
        str.append("    </GetLegendGraphic>\n");
    }

    private void capabilityException(StringBuilder str) {
        str.append("  <Exception>\n");
        str.append("    <Format>application/vnd.ogc.se_xml</Format>\n");
        str.append("  </Exception>\n");
    }

    private void capabilityVendorSpecific(StringBuilder str) {
        if (!this.renderTileSets) {
            return;
        }
        str.append("  <VendorSpecificCapabilities>\n");
        for (TileLayer layer : this.tld.getLayers().values()) {
            for (Grid grid : layer.getGrids().values()) {
                Iterator<MimeType> mimeIter = null;
                if (layer.getMimeTypes() != null) {
                    mimeIter = layer.getMimeTypes().iterator();
                } else {
                    ArrayList<ImageMime> arList = new ArrayList<ImageMime>();
                    arList.add(ImageMime.png);
                    arList.add(ImageMime.jpeg);
                    mimeIter = arList.iterator();
                }
                while (mimeIter.hasNext()) {
                    try {
                        this.capabilityVendorSpecificTileset(str, layer, grid, mimeIter.next().getFormat());
                    }
                    catch (GeoWebCacheException e) {
                        log.error((Object)e.getMessage());
                    }
                }
            }
        }
        str.append("  </VendorSpecificCapabilities>\n");
    }

    private void capabilityVendorSpecificTileset(StringBuilder str, TileLayer layer, Grid grid, String formatStr) throws GeoWebCacheException {
        String srsStr = grid.getSRS().toString();
        StringBuilder resolutionsStr = new StringBuilder();
        double[] res = grid.getResolutions();
        for (int i = 0; i < res.length; ++i) {
            resolutionsStr.append(Double.toString(res[i]) + " ");
        }
        String[] bs = this.boundsPrep(layer.getZoomedOutBbox(grid.getSRS()));
        str.append("    <TileSet>\n");
        str.append("      <SRS>" + srsStr + "</SRS>\n");
        str.append("      <BoundingBox srs=\"" + srsStr + "\" minx=\"" + bs[0] + "\" miny=\"" + bs[1] + "\"  maxx=\"" + bs[2] + "\"  maxy=\"" + bs[3] + "\" />\n");
        str.append("      <Resolutions>" + resolutionsStr.toString() + "</Resolutions>\n");
        str.append("      <Width>256</Width>\n");
        str.append("      <Height>256</Height>\n");
        str.append("      <Format>" + formatStr + "</Format>\n");
        str.append("      <Layers>" + layer.getName() + "</Layers>\n");
        str.append("      <Styles></Styles>\n");
        str.append("    </TileSet>\n");
    }

    private void capabilityLayerOuter(StringBuilder str) {
        str.append("  <Layer>\n");
        str.append("    <Title>GeoWebCache WMS</Title>\n");
        str.append("    <Abstract>Note that GeoWebCache does not provide full WMS services.</Abstract>\n");
        str.append("    <LatLonBoundingBox minx=\"-180.0\" miny=\"-90.0\" maxx=\"180.0\" maxy=\"90.0\"/>\n");
        for (TileLayer layer : this.tld.getLayers().values()) {
            try {
                this.capabilityLayerInner(str, layer);
            }
            catch (GeoWebCacheException e) {
                log.error((Object)e.getMessage());
            }
        }
        str.append("  </Layer>\n");
    }

    private void capabilityLayerInner(StringBuilder str, TileLayer layer) throws GeoWebCacheException {
        if (layer instanceof WMSLayer && ((WMSLayer)layer).isQueryable()) {
            str.append("    <Layer queryable=\"1\">\n");
        } else {
            str.append("    <Layer>\n");
        }
        str.append("      <Name>" + layer.getName() + "</Name>\n");
        str.append("      <Title>" + layer.getName() + "</Title>\n");
        Iterator<SRS> srsIter = layer.getGrids().keySet().iterator();
        while (srsIter.hasNext()) {
            str.append("      <SRS>" + srsIter.next().toString() + "</SRS>\n");
        }
        if (layer.getGrid(SRS.getEPSG4326()) != null) {
            String[] bs = this.boundsPrep(layer.getZoomedOutBbox(SRS.getEPSG4326()));
            str.append("      <LatLonBoundingBox minx=\"" + bs[0] + "\" miny=\"" + bs[1] + "\" maxx=\"" + bs[2] + "\" maxy=\"" + bs[3] + "\"/>\n");
        }
        for (Grid grid : layer.getGrids().values()) {
            String[] bs = this.boundsPrep(layer.getZoomedOutBbox(grid.getSRS()));
            str.append("      <BoundingBox SRS=\"" + grid.getSRS().toString() + "\" minx=\"" + bs[0] + "\" miny=\"" + bs[1] + "\" maxx=\"" + bs[2] + "\" maxy=\"" + bs[3] + "\"/>\n");
        }
        str.append("    </Layer>\n");
    }

    String[] boundsPrep(BBOX bbox) {
        String[] bs = new String[]{Double.toString(bbox.coords[0]), Double.toString(bbox.coords[1]), Double.toString(bbox.coords[2]), Double.toString(bbox.coords[3])};
        return bs;
    }
}

