/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.io.FilenameFilter;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRangeObject;

public class FilePathFilter
implements FilenameFilter {
    String srsPrefix = null;
    String mimeExtension = null;
    TileRangeObject tr;

    public FilePathFilter(TileRangeObject trObj) throws StorageException {
        this.tr = trObj;
        if (this.tr.srs == null) {
            throw new StorageException("Specifying the SRS is currently mandatory.");
        }
        this.srsPrefix = "EPSG_" + this.tr.srs.getNumber();
        if (this.tr.mimeType != null) {
            this.mimeExtension = this.tr.mimeType.getFileExtension();
        }
    }

    public boolean accept(File dir, String name) {
        boolean ret = name.startsWith("EPSG_") ? this.acceptZoomLevelDir(name) : (name.contains(".") ? this.acceptFileName(dir, name) : this.acceptIntermediateDir(name));
        return ret;
    }

    private boolean acceptZoomLevelDir(String name) {
        int tmp;
        if (!name.startsWith(this.srsPrefix)) {
            return false;
        }
        return this.tr.zoomStart == -1 && this.tr.zoomStop == -1 || (tmp = this.findZoomLevel(name)) >= this.tr.zoomStart && tmp <= this.tr.zoomStop;
    }

    private boolean acceptIntermediateDir(String name) {
        return true;
    }

    private boolean acceptFileName(File dir, String name) {
        String[] parts = name.split("\\.");
        if (!parts[parts.length - 1].equalsIgnoreCase(this.mimeExtension)) {
            return false;
        }
        if (this.tr.rangeBounds != null) {
            String[] coords = parts[0].split("_");
            int zoomLevel = this.findZoomLevel(dir.getParentFile().getName());
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            int[] box = this.tr.rangeBounds[zoomLevel];
            if (x < box[0] || x > box[2]) {
                return false;
            }
            if (y < box[1] || y > box[3]) {
                return false;
            }
        }
        return true;
    }

    private int findZoomLevel(String dirName) {
        return Integer.parseInt(dirName.substring(this.srsPrefix.length() + 1));
    }
}

