/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import org.geowebcache.mime.MimeType;

public class FilePathGenerator {
    protected static String[] tilePath(String prefix, String layerName, long[] tileIndex, int srsNumber, MimeType mimeType, long parameters_id) {
        long x = tileIndex[0];
        long y = tileIndex[1];
        long z = tileIndex[2];
        String srsStr = FilePathGenerator.filteredSRSName(srsNumber);
        String layerStr = FilePathGenerator.filteredLayerName(layerName);
        String paramStr = "";
        if (parameters_id != -1L) {
            paramStr = "_" + Long.toHexString(parameters_id);
        }
        long shift = z / 2L;
        long half = 2 << (int)shift;
        int digits = 1;
        if (half > 10L) {
            digits = (int)Math.log10(half) + 1;
        }
        long halfx = x / half;
        long halfy = y / half;
        String fileExtension = mimeType.getFileExtension();
        String[] ret = new String[]{prefix + File.separator + layerStr + File.separator + srsStr + "_" + FilePathGenerator.zeroPadder(z, 2) + paramStr + File.separator + FilePathGenerator.zeroPadder(halfx, digits) + "_" + FilePathGenerator.zeroPadder(halfy, digits), FilePathGenerator.zeroPadder(x, 2 * digits) + "_" + FilePathGenerator.zeroPadder(y, 2 * digits) + "." + fileExtension};
        return ret;
    }

    public static String zeroPadder(long number, int order) {
        int diffOrder;
        int numberOrder = 1;
        if (number > 9L) {
            numberOrder = number > 11L ? (int)Math.ceil(Math.log10(number) - 0.001) : 2;
        }
        StringBuilder padding = new StringBuilder(diffOrder);
        for (diffOrder = order - numberOrder; diffOrder > 0; --diffOrder) {
            padding.append("0");
        }
        return padding.toString() + Long.toString(number);
    }

    public static String filteredSRSName(int srsNumber) {
        return "EPSG_" + srsNumber;
    }

    public static String filteredLayerName(String layerName) {
        return layerName.replace(':', '_').replace(' ', '_');
    }
}

