/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.languages;

import java.util.regex.Pattern;
import org.openrdf.model.Literal;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.LiteralUtilException;
import org.openrdf.rio.LanguageHandler;

public class RFC3066LanguageHandler
implements LanguageHandler {
    protected final Pattern matcher = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    public boolean isRecognizedLanguage(String languageTag) {
        if (languageTag == null) {
            throw new NullPointerException("Language tag cannot be null");
        }
        boolean result = this.matcher.matcher(languageTag).matches();
        return result;
    }

    public boolean verifyLanguage(String literalValue, String languageTag) throws LiteralUtilException {
        if (this.isRecognizedLanguage(languageTag)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return this.matcher.matcher(languageTag).matches();
        }
        throw new LiteralUtilException("Could not verify RFC3066 language tag");
    }

    public Literal normalizeLanguage(String literalValue, String languageTag, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedLanguage(languageTag)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return valueFactory.createLiteral(literalValue, languageTag.toLowerCase());
        }
        throw new LiteralUtilException("Could not normalize RFC3066 language tag");
    }

    public String getKey() {
        return "org.openrdf.rio.languages.RFC3066";
    }
}

