/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.raw.extender.intern;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.exam.raw.extender.intern.Parser;
import org.ops4j.pax.exam.raw.extender.intern.Probe;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.pax.swissbox.extender.ManifestEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBundleObserver
implements BundleObserver<ManifestEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(TestBundleObserver.class);
    private final Map<Bundle, Registration> registrations = new HashMap<Bundle, Registration>();

    TestBundleObserver() {
    }

    public void addingEntries(Bundle bundle, List<ManifestEntry> manifestEntries) {
        String testExec = null;
        for (ManifestEntry manifestEntry : manifestEntries) {
            if (!"PaxExam-Executable".equals(manifestEntry.getKey())) continue;
            testExec = manifestEntry.getValue();
            break;
        }
        if (testExec != null) {
            Parser parser = new Parser(bundle.getBundleContext(), testExec, manifestEntries);
            for (Probe p : parser.getProbes()) {
                BundleContext bundleContext = BundleUtils.getBundleContext((Bundle)bundle);
                ServiceRegistration<?> serviceRegistration = p.register(bundleContext);
                this.registrations.put(bundle, new Registration(p, serviceRegistration));
            }
        }
    }

    public void removingEntries(Bundle bundle, List<ManifestEntry> manifestEntries) {
        Registration registration = this.registrations.remove(bundle);
        if (registration != null) {
            LOG.debug("Unregistered testcase [" + registration.probe + "." + "]");
        }
    }

    private static class Registration {
        final Probe probe;

        public Registration(Probe probe, ServiceRegistration<?> serviceRegistration) {
            this.probe = probe;
        }
    }
}

