/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.utils.InvalidSettingException;

@Mojo(name="update-only", requiresProject=false, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresOnline=true, aggregator=true)
public class UpdateMojo
extends BaseDependencyCheckMojo {
    public boolean canGenerateReport() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runCheck() throws MojoExecutionException, MojoFailureException {
        try (Engine engine = this.initializeEngine();){
            try {
                if (!engine.getSettings().getBoolean("odc.autoupdate")) {
                    engine.getSettings().setBoolean("odc.autoupdate", true);
                }
            }
            catch (InvalidSettingException ex) {
                engine.getSettings().setBoolean("odc.autoupdate", true);
            }
            engine.doUpdates();
        }
        catch (DatabaseException ex) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Database connection error", (Throwable)ex);
            }
            String msg = "An exception occurred connecting to the local database. Please see the log file for more details.";
            if (this.isFailOnError()) {
                throw new MojoExecutionException("An exception occurred connecting to the local database. Please see the log file for more details.", (Exception)((Object)ex));
            }
            this.getLog().error((CharSequence)"An exception occurred connecting to the local database. Please see the log file for more details.");
        }
        catch (UpdateException ex) {
            String msg = "An exception occurred while downloading updates. Please see the log file for more details.";
            if (this.isFailOnError()) {
                throw new MojoExecutionException("An exception occurred while downloading updates. Please see the log file for more details.", (Exception)((Object)ex));
            }
            this.getLog().error((CharSequence)"An exception occurred while downloading updates. Please see the log file for more details.");
        }
        finally {
            this.getSettings().cleanup();
        }
    }

    public String getName(Locale locale) {
        return "dependency-check-update";
    }

    public String getDescription(Locale locale) {
        return "Updates the local cache of the NVD data from NIST.";
    }

    @Override
    protected ExceptionCollection scanDependencies(Engine engine) throws MojoExecutionException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected ExceptionCollection scanPlugins(Engine engine, ExceptionCollection exCollection) throws MojoExecutionException {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

