/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Constructor;
import org.mockito.Matchers;
import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.ConstructorExpectationSetup;
import org.powermock.api.mockito.expectation.WithExpectedArguments;
import org.powermock.api.mockito.internal.expectation.DelegatingToConstructorsOngoingStubbing;
import org.powermock.api.mockito.internal.invocation.MockitoNewInvocationControl;
import org.powermock.api.mockito.internal.mockcreation.MockCreator;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.impl.ArrayMergerImpl;

public class DefaultConstructorExpectationSetup<T>
implements ConstructorExpectationSetup<T> {
    private Class<?>[] parameterTypes = null;
    private final Class<T> mockType;
    private final ArrayMerger arrayMerger;

    public DefaultConstructorExpectationSetup(Class<T> mockType) {
        this.mockType = mockType;
        this.arrayMerger = new ArrayMergerImpl();
    }

    void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    OngoingStubbing<T> withArguments(Object[] additionalArguments) throws Exception {
        return DefaultConstructorExpectationSetup.createNewSubstituteMock(this.mockType, this.parameterTypes, additionalArguments);
    }

    @Override
    public OngoingStubbing<T> withArguments(Object firstArgument, Object ... additionalArguments) throws Exception {
        return DefaultConstructorExpectationSetup.createNewSubstituteMock(this.mockType, this.parameterTypes, this.arrayMerger.mergeArrays(Object.class, (Object[][])new Object[][]{{firstArgument}, additionalArguments}));
    }

    @Override
    public OngoingStubbing<T> withAnyArguments() throws Exception {
        if (this.mockType == null) {
            throw new IllegalArgumentException("Class to expected cannot be null");
        }
        Class unmockedType = WhiteboxImpl.getUnmockedType(this.mockType);
        Constructor[] allConstructors = WhiteboxImpl.getAllConstructors((Class)unmockedType);
        Constructor constructor = allConstructors[0];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] paramArgs = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            paramArgs[i] = Matchers.any(paramType);
        }
        OngoingStubbing<T> ongoingStubbing = DefaultConstructorExpectationSetup.createNewSubstituteMock(this.mockType, parameterTypes, paramArgs);
        Constructor[] otherCtors = new Constructor[allConstructors.length - 1];
        System.arraycopy(allConstructors, 1, otherCtors, 0, allConstructors.length - 1);
        return new DelegatingToConstructorsOngoingStubbing<T>(otherCtors, ongoingStubbing);
    }

    @Override
    public OngoingStubbing<T> withNoArguments() throws Exception {
        return DefaultConstructorExpectationSetup.createNewSubstituteMock(this.mockType, this.parameterTypes, new Object[0]);
    }

    @Override
    public WithExpectedArguments<T> withParameterTypes(Class<?> parameterType, Class<?> ... additionalParameterTypes) {
        this.parameterTypes = (Class[])this.arrayMerger.mergeArrays(Class.class, (Object[][])new Class[][]{{parameterType}, additionalParameterTypes});
        return this;
    }

    private static <T> OngoingStubbing<T> createNewSubstituteMock(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class unmockedType = WhiteboxImpl.getUnmockedType(type);
        if (parameterTypes == null) {
            WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])arguments);
        } else {
            WhiteboxImpl.getConstructor((Class)unmockedType, (Class[])parameterTypes);
        }
        MockitoNewInvocationControl newInvocationControl = MockRepository.getNewInstanceControl((Class)unmockedType);
        if (newInvocationControl == null) {
            InvocationSubstitute mock = MockCreator.mock(InvocationSubstitute.class, false, false, null, null, null);
            newInvocationControl = new MockitoNewInvocationControl(mock);
            MockRepository.putNewInstanceControl(type, newInvocationControl);
            MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{WhiteboxImpl.getUnmockedType(type)});
        }
        return (OngoingStubbing)newInvocationControl.expectSubstitutionLogic(arguments);
    }
}

