/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ToString;
import org.fest.util.Strings;

public final class Formatting {
    private static final String EMPTY_MESSAGE = "";

    static String createMessageFrom(Description description, Object[] message) {
        return Formatting.format(description, Strings.concat(message));
    }

    public static String format(Description description, String message) {
        String s = Formatting.valueOf(description);
        return Strings.concat(Formatting.format(s), message);
    }

    public static String valueOf(Description description) {
        return description == null ? null : description.value();
    }

    public static String format(String message) {
        if (Strings.isEmpty(message)) {
            return EMPTY_MESSAGE;
        }
        return Strings.concat("[", message, "] ");
    }

    public static String inBrackets(Object o) {
        return Formatting.doBracketAround(ToString.toStringOf(o));
    }

    private static String doBracketAround(Object o) {
        return Strings.concat("<", o, ">");
    }

    private Formatting() {
    }
}

