/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.beanproperty;

import org.fest.reflect.beanproperty.PropertyType;
import org.fest.reflect.beanproperty.PropertyTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyName {
    private final String name;

    public static PropertyName startPropertyAccess(String name) {
        PropertyName.validateIsNotNullOrEmpty(name);
        return new PropertyName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the property to access should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the property to access should not be empty");
        }
    }

    private PropertyName(String name) {
        this.name = name;
    }

    public <T> PropertyType<T> ofType(Class<T> type) {
        return PropertyType.newPropertyType(this.name, type);
    }

    public <T> PropertyTypeRef<T> ofType(TypeRef<T> type) {
        return PropertyTypeRef.newPropertyTypeRef(this.name, type);
    }
}

