/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.data.TableCell;
import org.fest.util.Strings;

public final class JTableCellValidator {
    @RunsInCurrentThread
    public static void validateCellIsEditable(JTable table, int row, int column) {
        if (!table.isCellEditable(row, column)) {
            throw new IllegalStateException(Strings.concat("Expecting the cell [", String.valueOf(row), ",", String.valueOf(column), "] to be editable"));
        }
    }

    @RunsInCurrentThread
    public static void validateCellIndices(JTable table, TableCell cell) {
        JTableCellValidator.validateNotNull(cell);
        JTableCellValidator.validateIndices(table, cell.row, cell.column);
    }

    public static void validateNotNull(TableCell cell) {
        if (cell == null) {
            throw new NullPointerException("Table cell cannot be null");
        }
    }

    @RunsInCurrentThread
    public static void validateIndices(JTable table, int row, int column) {
        if (table.getRowCount() == 0) {
            throw new IndexOutOfBoundsException("Table does not contain any rows");
        }
        JTableCellValidator.validateRowIndex(table, row);
        JTableCellValidator.validateColumnIndex(table, column);
    }

    @RunsInCurrentThread
    public static void validateRowIndex(JTable table, int row) {
        JTableCellValidator.validateIndex(row, table.getRowCount(), "row");
    }

    @RunsInCurrentThread
    public static void validateColumnIndex(JTable table, int column) {
        JTableCellValidator.validateIndex(column, table.getColumnCount(), "column");
    }

    @RunsInCurrentThread
    private static void validateIndex(int index, int itemCount, String indexName) {
        if (index >= 0 && index < itemCount) {
            return;
        }
        throw new IndexOutOfBoundsException(Strings.concat(indexName, " ", Strings.quote(String.valueOf(index)), " should be between <0> and <", String.valueOf(itemCount - 1), ">"));
    }

    private JTableCellValidator() {
    }
}

