/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Font;
import org.fest.assertions.Assertions;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.util.Strings;

public class FontFixture {
    private static final String PROPERTY_SEPARATOR = " - ";
    private static final String BOLD_PROPERTY = "bold";
    private static final String FAMILY_PROPERTY = "family";
    private static final String ITALIC_PROPERTY = "italic";
    private static final String NAME_PROPERTY = "name";
    private static final String PLAIN_PROPERTY = "plain";
    private static final String SIZE_PROPERTY = "size";
    private final Font target;
    private final Description description;

    public FontFixture(Font target) {
        this(target, (Description)null);
    }

    public FontFixture(Font target, String description) {
        this(target, new BasicDescription(description));
    }

    public FontFixture(Font target, Description description) {
        if (target == null) {
            throw new NullPointerException("The given font should not be null");
        }
        this.target = target;
        this.description = description;
    }

    public FontFixture requireFamily(String family) {
        Assertions.assertThat(this.target.getFamily()).as(this.property(FAMILY_PROPERTY)).isEqualTo(family);
        return this;
    }

    public FontFixture requireName(String name) {
        Assertions.assertThat(this.target.getName()).as(this.property(NAME_PROPERTY)).isEqualTo(name);
        return this;
    }

    public FontFixture requireSize(int size) {
        Assertions.assertThat(this.target.getSize()).as(this.property(SIZE_PROPERTY)).isEqualTo(size);
        return this;
    }

    public FontFixture requireBold() {
        return this.requireBold(true);
    }

    public FontFixture requireNotBold() {
        return this.requireBold(false);
    }

    private FontFixture requireBold(boolean bold) {
        Assertions.assertThat(this.target.isBold()).as(this.property(BOLD_PROPERTY)).isEqualTo(bold);
        return this;
    }

    public FontFixture requireItalic() {
        return this.requireItalic(true);
    }

    public FontFixture requireNotItalic() {
        return this.requireItalic(false);
    }

    private FontFixture requireItalic(boolean italic) {
        Assertions.assertThat(this.target.isItalic()).as(this.property(ITALIC_PROPERTY)).isEqualTo(italic);
        return this;
    }

    public FontFixture requirePlain() {
        return this.requirePlain(true);
    }

    public FontFixture requireNotPlain() {
        return this.requirePlain(false);
    }

    private FontFixture requirePlain(boolean plain) {
        Assertions.assertThat(this.target.isBold()).as(this.property(PLAIN_PROPERTY)).isEqualTo(plain);
        return this;
    }

    private String property(String s) {
        if (!Strings.isEmpty(this.description())) {
            return Strings.concat(this.description.value(), PROPERTY_SEPARATOR, s);
        }
        return s;
    }

    public Font target() {
        return this.target;
    }

    public final String description() {
        return this.description != null ? this.description.value() : null;
    }
}

