/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.optimizer.AnnotationConstantsCollector;
import org.objectweb.asm.optimizer.ConstantPool;

public class MethodConstantsCollector
extends MethodAdapter {
    private ConstantPool cp;

    public MethodConstantsCollector(MethodVisitor methodVisitor, ConstantPool constantPool) {
        super(methodVisitor);
        this.cp = constantPool;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.cp.newUTF8("AnnotationDefault");
        return new AnnotationConstantsCollector(this.mv.visitAnnotationDefault(), this.cp);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.cp.newUTF8(string);
        if (bl) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitAnnotation(string, bl), this.cp);
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.cp.newUTF8(string);
        if (bl) {
            this.cp.newUTF8("RuntimeVisibleParameterAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleParameterAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitParameterAnnotation(n, string, bl), this.cp);
    }

    public void visitTypeInsn(int n, String string) {
        this.cp.newClass(string);
        this.mv.visitTypeInsn(n, string);
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.cp.newField(string, string2, string3);
        this.mv.visitFieldInsn(n, string, string2, string3);
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        boolean bl = n == 185;
        this.cp.newMethod(string, string2, string3, bl);
        this.mv.visitMethodInsn(n, string, string2, string3);
    }

    public void visitLdcInsn(Object object) {
        this.cp.newConst(object);
        this.mv.visitLdcInsn(object);
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.cp.newClass(string);
        this.mv.visitMultiANewArrayInsn(string, n);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        if (string != null) {
            this.cp.newClass(string);
        }
        this.mv.visitTryCatchBlock(label, label2, label3, string);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        if (string3 != null) {
            this.cp.newUTF8("LocalVariableTypeTable");
            this.cp.newUTF8(string);
            this.cp.newUTF8(string3);
        }
        this.cp.newUTF8("LocalVariableTable");
        this.cp.newUTF8(string);
        this.cp.newUTF8(string2);
        this.mv.visitLocalVariable(string, string2, string3, label, label2, n);
    }

    public void visitLineNumber(int n, Label label) {
        this.cp.newUTF8("LineNumberTable");
        this.mv.visitLineNumber(n, label);
    }

    public void visitMaxs(int n, int n2) {
        this.cp.newUTF8("Code");
        this.mv.visitMaxs(n, n2);
    }
}

