/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.flamingo.common.TransitionAwareResizableIcon;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonBandBorder;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceRibbonBandUI
extends BasicRibbonBandUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonBandUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        SubstanceLookAndFeel.setDecorationType((JComponent)this.ribbonBand, (DecorationAreaType)DecorationAreaType.GENERAL);
        Color backgr = this.ribbonBand.getBackground();
        if (backgr == null || backgr instanceof UIResource) {
            Color toSet = SubstanceColorSchemeUtilities.getColorScheme((Component)this.ribbonBand, (ComponentState)ComponentState.ENABLED).getBackgroundFillColor();
            this.ribbonBand.setBackground((Color)new ColorUIResource(toSet));
        }
    }

    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.ribbonBand);
        super.uninstallDefaults();
    }

    protected void installComponents() {
        super.installComponents();
        SubstanceLookAndFeel.setDecorationType((JComponent)this.ribbonBand, (DecorationAreaType)DecorationAreaType.GENERAL);
        if (this.expandButton != null) {
            this.expandButton.putClientProperty((Object)"substancelaf.useThemedDefaultIcons", (Object)Boolean.FALSE);
            this.expandButton.setFocusable(false);
        }
    }

    protected void paintBandTitle(Graphics graphics, Rectangle titleRectangle, String title) {
        if (titleRectangle.width <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setFont(UIManager.getFont("Ribbon.font"));
        FontMetrics fm = graphics.getFontMetrics();
        int currLength = (int)fm.getStringBounds(title, g2d).getWidth();
        String titleToPaint = title;
        while (currLength > titleRectangle.width) {
            title = title.substring(0, title.length() - 1);
            titleToPaint = String.valueOf(title) + "...";
            currLength = (int)fm.getStringBounds(titleToPaint, g2d).getWidth();
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)this.ribbonBand);
        SubstanceColorScheme bgColorScheme = skin.getBackgroundColorScheme(DecorationAreaType.HEADER);
        Color bgFillColor = bgColorScheme.getBackgroundFillColor();
        Color fgColor = bgColorScheme.getForegroundColor();
        fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)0.8f);
        g2d.setColor(fgColor);
        int deltaX = (titleRectangle.width - currLength) / 2;
        int deltaY = (titleRectangle.height - fm.getAscent() - fm.getDescent()) / 2;
        Rectangle smallTitleRectangle = new Rectangle(titleRectangle.x + deltaX, titleRectangle.y + deltaY, titleRectangle.width - 2 * deltaX, titleRectangle.height - 2 * deltaY);
        SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)this.ribbonBand, (Rectangle)smallTitleRectangle, (String)titleToPaint, (int)-1, (Font)g2d.getFont(), (Color)g2d.getColor(), (Rectangle)g2d.getClipBounds());
        g2d.dispose();
    }

    protected void paintBandTitleBackground(Graphics g, Rectangle titleRectangle, String title) {
        MatteFillPainter gradientPainter = new MatteFillPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)this.ribbonBand);
        SubstanceColorScheme colorScheme = skin.getBackgroundColorScheme(DecorationAreaType.HEADER);
        boolean isDark = colorScheme.isDark();
        float alpha = 0.85f - (isDark ? 0.15f : 0.35f) * this.rolloverAmount;
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.ribbonBand, (float)alpha, (Graphics)g));
        SubstanceRibbonBandBorder border = (SubstanceRibbonBandBorder)this.ribbonBand.getBorder();
        float cornerRadius = border.getCornerRadius((Component)this.ribbonBand);
        GeneralPath outline = new GeneralPath();
        outline.moveTo(0.0f, 0.0f);
        outline.lineTo(titleRectangle.width, 0.0f);
        outline.lineTo(titleRectangle.width, (float)titleRectangle.height - cornerRadius - 1.0f);
        outline.append(new Arc2D.Double((float)titleRectangle.width - 2.0f * cornerRadius - 1.0f, (float)(titleRectangle.height - 1) - 2.0f * cornerRadius, 2.0f * cornerRadius, 2.0f * cornerRadius, 0.0, -90.0, 0), true);
        outline.lineTo(cornerRadius, titleRectangle.height - 1);
        outline.append(new Arc2D.Double(0.0, (float)titleRectangle.height - 2.0f * cornerRadius - 1.0f, 2.0f * cornerRadius, 2.0f * cornerRadius, 270.0, -90.0, 0), true);
        outline.lineTo(0.0f, 0.0f);
        g2d.translate(titleRectangle.x, titleRectangle.y);
        gradientPainter.paintContourBackground((Graphics)g2d, (Component)this.ribbonBand, titleRectangle.width, titleRectangle.height, (Shape)outline, false, colorScheme, false);
        g2d.setColor(colorScheme.getMidColor());
        g2d.setStroke(new BasicStroke(1.2f));
        g2d.draw(outline);
        SubstanceColorScheme separatorScheme = SubstanceLookAndFeel.getCurrentSkin((Component)this.ribbonBand).getColorScheme(DecorationAreaType.HEADER, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.ribbonBand, (float)(alpha * 0.7f), (Graphics)g));
        SeparatorPainterUtils.paintSeparator((Component)this.ribbonBand, (Graphics)g2d, (SubstanceColorScheme)separatorScheme, (int)titleRectangle.width, (int)1, (int)0, (boolean)false, (int)0, (int)0, (boolean)true);
        g2d.dispose();
    }

    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        SubstanceRibbonBandUI.paintRibbonBandBackground(graphics, (Component)this.ribbonBand, this.rolloverAmount, 0);
    }

    public static void paintRibbonBandBackground(Graphics graphics, Component comp, float rolloverAmount, int dy) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)comp);
        SubstanceColorScheme bgScheme = skin.getBackgroundColorScheme(SubstanceLookAndFeel.getDecorationType((Component)comp));
        int offset = 20 - dy;
        float bp = (float)offset / (float)comp.getHeight();
        Color c1 = bgScheme.getUltraLightColor();
        Color c2 = SubstanceColorUtilities.getInterpolatedColor((Color)bgScheme.getUltraLightColor(), (Color)bgScheme.getExtraLightColor(), (double)rolloverAmount);
        Color c3 = SubstanceColorUtilities.getInterpolatedColor((Color)bgScheme.getExtraLightColor(), (Color)bgScheme.getLightColor(), (double)rolloverAmount);
        Color c4 = SubstanceColorUtilities.getInterpolatedColor((Color)bgScheme.getUltraLightColor(), (Color)bgScheme.getExtraLightColor(), (double)rolloverAmount);
        LinearGradientPaint fillPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, comp.getHeight(), new float[]{0.0f, bp - 1.0E-5f, bp, 1.0f}, new Color[]{c1, c2, c3, c4});
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setPaint(fillPaint);
        g2d.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        SubstanceWatermark watermark = skin.getWatermark();
        if (watermark != null && SubstanceCoreUtilities.toDrawWatermark((Component)comp)) {
            watermark.drawWatermarkImage((Graphics)g2d, comp, 0, 0, comp.getWidth(), comp.getHeight());
        }
        g2d.dispose();
    }

    public int getBandTitleHeight() {
        return 1 + SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbonBand), (int)17, (int)1, (int)1, (boolean)false);
    }

    protected JCommandButton createExpandButton() {
        RibbonBandExpandButton result = new RibbonBandExpandButton();
        SubstanceLookAndFeel.setDecorationType((JComponent)((Object)result), (DecorationAreaType)DecorationAreaType.HEADER);
        result.setIcon(SubstanceRibbonBandUI.getExpandButtonIcon((AbstractCommandButton)result));
        return result;
    }

    private static ResizableIcon getExpandButtonIcon(final AbstractCommandButton button) {
        final int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize) + 2;
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return ((ActionPopupTransitionAwareUI)button.getUI()).getActionTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                return SubstanceImageCreator.getDoubleArrowIcon((int)SubstanceSizeUtils.getComponentFontSize((Component)button), (float)width, (float)height, (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(button.getComponentOrientation().isLeftToRight() ? 3 : 7), (SubstanceColorScheme)scheme);
            }
        }, new Dimension(arrowIconWidth, arrowIconHeight));
        return arrowIcon;
    }

    protected void syncExpandButtonIcon() {
        ResizableIcon icon = SubstanceRibbonBandUI.getExpandButtonIcon(this.expandButton);
        this.expandButton.setIcon(icon);
    }

    private class RibbonBandExpandButton
    extends JCommandButton
    implements SubstanceInternalButton {
        public RibbonBandExpandButton() {
            super(null, null);
            this.setFocusable(false);
            this.setBorder(new EmptyBorder(3, 2, 3, 2));
            this.setActionKeyTip(SubstanceRibbonBandUI.this.ribbonBand.getExpandButtonKeyTip());
            this.setActionRichTooltip(SubstanceRibbonBandUI.this.ribbonBand.getExpandButtonRichTooltip());
        }
    }
}

