/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import org.sikuli.script.Debug;
import org.sikuli.script.Env;
import org.sikuli.script.OSUtil;
import org.sikuli.script.Region;

public class App {
    protected static OSUtil _osUtil = Env.getOSUtil();
    protected String _appName;
    protected int _pid;

    public App(String string) {
        this._appName = string;
        this._pid = 0;
    }

    protected App(String string, int n) {
        this._appName = string;
        this._pid = n;
    }

    public static App open(String string) {
        return new App(string).open();
    }

    public static int close(String string) {
        return _osUtil.closeApp(string);
    }

    public static App focus(String string) {
        return new App(string).focus();
    }

    public static App focus(String string, int n) {
        return new App(string).focus(n);
    }

    public App focus() {
        return this.focus(0);
    }

    public App focus(int n) {
        Debug.history("App.focus " + this.toString() + " #" + n, new Object[0]);
        if (this._pid != 0) {
            if (_osUtil.switchApp(this._pid, n) == 0) {
                Debug.error("App.focus failed: " + this._appName + "(" + this._pid + ") not found", new Object[0]);
                return null;
            }
        } else {
            boolean bl = false;
            if (Env.isWindows()) {
                this._pid = _osUtil.switchApp(this._appName, n);
                if (this._pid == 0) {
                    bl = true;
                }
            } else if (_osUtil.switchApp(this._appName, n) < 0) {
                bl = true;
            }
            if (bl) {
                Debug.error("App.focus failed: " + this._appName + " not found", new Object[0]);
                return null;
            }
        }
        return this;
    }

    public App open() {
        if (Env.isWindows() || Env.isLinux()) {
            int n;
            this._pid = n = _osUtil.openApp(this._appName);
            Debug.history("App.open " + this.toString(), new Object[0]);
            if (n == 0) {
                Debug.error("App.open failed: " + this._appName + " not found", new Object[0]);
                return null;
            }
        } else {
            Debug.history("App.open " + this.toString(), new Object[0]);
            if (_osUtil.openApp(this._appName) < 0) {
                Debug.error("App.open failed: " + this._appName + " not found", new Object[0]);
                return null;
            }
        }
        return this;
    }

    public int close() {
        int n;
        Debug.history("App.close " + this.toString(), new Object[0]);
        if (this._pid != 0 && (n = _osUtil.closeApp(this._pid)) >= 0) {
            return n;
        }
        return App.close(this._appName);
    }

    public String name() {
        return this._appName;
    }

    public Region window() {
        if (this._pid != 0) {
            return _osUtil.getWindow(this._pid);
        }
        return _osUtil.getWindow(this._appName);
    }

    public Region window(int n) {
        if (this._pid != 0) {
            return _osUtil.getWindow(this._pid, n);
        }
        return _osUtil.getWindow(this._appName, n);
    }

    public static Region focusedWindow() {
        return _osUtil.getFocusedWindow();
    }

    public String toString() {
        return this._appName + "(" + this._pid + ")";
    }
}

