/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.Date;
import org.sikuli.script.Settings;

public class Debug {
    private static final int DEBUG_LEVEL;
    private static final int DEFAULT_LEVEL = 1;
    private long _beginTime;

    public static void log(int n, String string, String string2, Object ... objectArray) {
        if (Debug.isEnabled(n)) {
            if (objectArray.length != 0) {
                System.out.printf(string + string2, objectArray);
            } else {
                System.out.print(string + string2);
            }
            System.out.println();
        }
    }

    public static void log(int n, String string, Object ... objectArray) {
        if (Settings.DebugLogs) {
            Debug.log(n, "[debug] ", string, objectArray);
        }
    }

    public static boolean isEnabled(int n) {
        return n <= DEBUG_LEVEL;
    }

    public static boolean isEnabled() {
        return Debug.isEnabled(1);
    }

    public static void log(String string, Object ... objectArray) {
        Debug.log(1, string, objectArray);
    }

    public static void history(String string, Object ... objectArray) {
        if (Settings.ActionLogs) {
            Debug.log(-1, "[log] ", string, objectArray);
        }
    }

    public static void info(String string, Object ... objectArray) {
        if (Settings.InfoLogs) {
            Debug.log(-1, "[info] ", string, objectArray);
        }
    }

    public static void error(String string, Object ... objectArray) {
        Debug.log(-1, "[error] ", string, objectArray);
    }

    public static void profile(String string, Object ... objectArray) {
        if (Settings.ProfileLogs) {
            Debug.log(-1, "[profile] ", string, objectArray);
        }
    }

    public void startTiming(String string) {
        if (Settings.ProfileLogs) {
            Debug.profile(string + " START", new Object[0]);
            this._beginTime = new Date().getTime();
        }
    }

    public long endTiming(String string) {
        if (Settings.ProfileLogs) {
            long l = new Date().getTime();
            long l2 = l - this._beginTime;
            Debug.profile(string + " END: " + l2 + "ms", new Object[0]);
            return l2;
        }
        return 0L;
    }

    static {
        String string = System.getProperty("sikuli.Debug");
        DEBUG_LEVEL = string == null ? 1 : (string == "" ? 0 : Integer.parseInt(string));
    }
}

