/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.sikuli.script.Clipboard;
import org.sikuli.script.Debug;
import org.sikuli.script.HotkeyListener;
import org.sikuli.script.Location;
import org.sikuli.script.OS;
import org.sikuli.script.OSUtil;
import org.sikuli.script.internal.hotkey.HotkeyManager;

public class Env {
    static final String SikuliVersion = "X-1.0rc3";
    static OSUtil _osUtil = null;

    public static Location getMouseLocation() throws HeadlessException {
        Point point = MouseInfo.getPointerInfo().getLocation();
        return new Location(point.x, point.y);
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static OS getOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os x")) {
            return OS.MAC;
        }
        if (string.startsWith("windows")) {
            return OS.WINDOWS;
        }
        if (string.startsWith("linux")) {
            return OS.LINUX;
        }
        return OS.NOT_SUPPORTED;
    }

    public static boolean isWindows() {
        return Env.getOS() == OS.WINDOWS;
    }

    public static boolean isLinux() {
        return Env.getOS() == OS.LINUX;
    }

    public static boolean isMac() {
        return Env.getOS() == OS.MAC;
    }

    public static String getSeparator() {
        if (Env.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static String getClipboard() {
        Transferable transferable = Clipboard.getSystemClipboard().getContents(null);
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return transferable.getTransferData(DataFlavor.stringFlavor).toString();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Debug.error("UnsupportedFlavorException: " + transferable, new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    static String getOSUtilClass() {
        String string = "org.sikuli.script.";
        switch (Env.getOS()) {
            case MAC: {
                return string + "MacUtil";
            }
            case WINDOWS: {
                return string + "Win32Util";
            }
            case LINUX: {
                return string + "LinuxUtil";
            }
        }
        Debug.error("Warning: Sikuli doesn't fully support your OS.", new Object[0]);
        return string + "DummyUtil";
    }

    public static OSUtil getOSUtil() {
        if (_osUtil == null) {
            try {
                Class<?> clazz = Class.forName(Env.getOSUtilClass());
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                _osUtil = (OSUtil)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Debug.error("Can't create OS Util: " + exception.getMessage(), new Object[0]);
            }
        }
        return _osUtil;
    }

    public static boolean isLockOn(char c) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        switch (c) {
            case '\ue025': {
                return toolkit.getLockingKeyState(145);
            }
            case '\ue027': {
                return toolkit.getLockingKeyState(20);
            }
            case '\ue03b': {
                return toolkit.getLockingKeyState(144);
            }
        }
        return false;
    }

    static int getHotkeyModifier() {
        if (Env.getOS() == OS.MAC) {
            return 157;
        }
        return 17;
    }

    static String getSikuliDataPath() {
        String string;
        String string2;
        if (Env.isWindows()) {
            string2 = System.getenv("APPDATA");
            string = "Sikuli";
        } else if (Env.isMac()) {
            string2 = System.getProperty("user.home") + "/Library/Application Support";
            string = "Sikuli";
        } else {
            string2 = System.getProperty("user.home");
            string = ".sikuli";
        }
        File file = new File(string2, string);
        return file.getAbsolutePath();
    }

    public static String getSikuliVersion() {
        return SikuliVersion;
    }

    public static boolean addHotkey(String string, int n, HotkeyListener hotkeyListener) {
        return HotkeyManager.getInstance().addHotkey(string, n, hotkeyListener);
    }

    public static boolean addHotkey(char c, int n, HotkeyListener hotkeyListener) {
        return HotkeyManager.getInstance().addHotkey(c, n, hotkeyListener);
    }

    public static boolean removeHotkey(String string, int n) {
        return HotkeyManager.getInstance().removeHotkey(string, n);
    }

    public static boolean removeHotkey(char c, int n) {
        return HotkeyManager.getInstance().removeHotkey(c, n);
    }

    public static void cleanUp() {
        HotkeyManager.getInstance().cleanUp();
    }
}

