/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import com.wapmx.nativeutils.jniloader.NativeLoader;
import java.awt.AWTException;
import java.io.IOException;
import java.util.Iterator;
import org.sikuli.script.Debug;
import org.sikuli.script.IScreen;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.OpenCV;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.TextRecognizer;
import org.sikuli.script.Util;
import org.sikuli.script.natives.FindInput;
import org.sikuli.script.natives.FindResult;
import org.sikuli.script.natives.FindResults;
import org.sikuli.script.natives.Mat;
import org.sikuli.script.natives.Vision;

public class Finder
implements Iterator<Match> {
    private Region _region = null;
    private Pattern _pattern = null;
    private FindInput _findInput = new FindInput();
    private FindResults _results = null;
    private ImageLocator _imgLocator = null;
    private int _cur_result_i;

    public Finder __enter__() {
        return this;
    }

    public void __exit__(Object object, Object object2, Object object3) {
        this.destroy();
    }

    public Finder(String string) throws IOException {
        this(string, null);
    }

    public Finder(String string, Region region) throws IOException {
        String string2 = this.findImageFile(string);
        this._findInput.setSource(string2);
        this._region = region;
    }

    public Finder(ScreenImage screenImage, Region region) {
        Mat mat = OpenCV.convertBufferedImageToMat(screenImage.getImage());
        this._findInput.setSource(mat);
        this._region = region;
    }

    public void __del__() {
        this.destroy();
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    protected String findImageFile(String string) throws IOException {
        if (this._imgLocator == null) {
            this._imgLocator = new ImageLocator();
        }
        return this._imgLocator.locate(string);
    }

    protected <PSC> void setFindInput(PSC PSC) throws IOException {
        if (PSC instanceof Pattern) {
            this._pattern = (Pattern)PSC;
            Mat mat = OpenCV.convertBufferedImageToMat(this._pattern.getImage());
            this._findInput.setTarget(mat);
            this._findInput.setSimilarity(this._pattern.similarity);
        } else if (PSC instanceof String) {
            this.setTargetSmartly(this._findInput, (String)PSC);
            this._findInput.setSimilarity(Settings.MinSimilarity);
        }
    }

    protected void setTargetSmartly(FindInput findInput, String string) {
        try {
            String string2 = this.findImageFile(string);
            findInput.setTarget(0, string2);
        }
        catch (IOException iOException) {
            if (Util.isImageFile(string)) {
                Debug.error(string + " looks like a file, but can't be found on the disk. Assume it's text.", new Object[0]);
            }
            TextRecognizer textRecognizer = TextRecognizer.getInstance();
            findInput.setTarget(1, string);
        }
    }

    public <PSC> void find(PSC PSC) throws IOException {
        this.setFindInput(PSC);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
    }

    public void find(String string, double d) throws IOException {
        this.setTargetSmartly(this._findInput, string);
        this._findInput.setSimilarity(d);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
    }

    public <PSC> void findAll(PSC PSC) throws IOException {
        Debug debug = new Debug();
        debug.startTiming("Finder.findAll");
        this.setFindInput(PSC);
        this._findInput.setFindAll(true);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        debug.endTiming("Finder.findAll");
    }

    public void findAll(String string, double d) throws IOException {
        Debug debug = new Debug();
        debug.startTiming("Finder.findAll");
        this.setTargetSmartly(this._findInput, string);
        this._findInput.setSimilarity(d);
        this._findInput.setFindAll(true);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        debug.endTiming("Finder.findAll");
    }

    @Override
    public boolean hasNext() {
        return this._results != null && this._results.size() > (long)this._cur_result_i;
    }

    @Override
    public Match next() {
        Match match = null;
        if (this.hasNext()) {
            FindResult findResult = this._results.get(this._cur_result_i++);
            IScreen iScreen = null;
            if (this._region != null) {
                iScreen = this._region.getScreen();
            }
            try {
                match = new Match(findResult, iScreen);
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            if (this._region != null) {
                match = this._region.toGlobalCoord(match);
            }
            if (this._pattern != null) {
                Location location = this._pattern.getTargetOffset();
                match.setTargetOffset(location);
            }
        }
        return match;
    }

    @Override
    public void remove() {
    }

    public void destroy() {
    }

    static {
        try {
            NativeLoader.loadLibrary("VisionProxy");
            Debug.info("Sikuli vision engine loaded.", new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

