/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.natives.FindResult;

public class Match
extends Region
implements Comparable {
    double score;
    private Location _target = null;

    public Match(int n, int n2, int n3, int n4, double d, IScreen iScreen) throws AWTException {
        this.init(n, n2, n3, n4, iScreen);
        this.score = d;
    }

    public Match(Match match, IScreen iScreen) throws AWTException {
        this.init(match.x, match.y, match.w, match.h, iScreen);
        this.score = match.score;
    }

    public Match(FindResult findResult, IScreen iScreen) throws AWTException {
        this.init(findResult.getX(), findResult.getY(), findResult.getW(), findResult.getH(), iScreen);
        this.score = findResult.getScore();
    }

    public int compareTo(Object object) {
        Match match = (Match)object;
        if (this.score != match.score) {
            return this.score < match.score ? -1 : 1;
        }
        if (this.x != match.x) {
            return this.x - match.x;
        }
        if (this.y != match.y) {
            return this.y - match.y;
        }
        if (this.w != match.w) {
            return this.w - match.w;
        }
        if (this.h != match.h) {
            return this.h - match.h;
        }
        if (this.equals(object)) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Match)) {
            return false;
        }
        Match match = (Match)object;
        return this.x == match.x && this.y == match.y && this.w == match.w && this.h == match.h && Math.abs(this.score - match.score) < 1.0E-5 && this.getTarget().equals(match.getTarget());
    }

    public double getScore() {
        return this.score;
    }

    public Location getTarget() {
        if (this._target != null) {
            return this._target;
        }
        return this.getCenter();
    }

    @Override
    public String toString() {
        String string = "center";
        Location location = this.getCenter();
        if (this._target != null && !location.equals(this._target)) {
            string = this._target.toString();
        }
        return String.format("Match[%d,%d %dx%d score=%.2f target=%s]", this.x, this.y, this.w, this.h, this.score, string);
    }

    void setTargetOffset(Location location) {
        this._target = new Location(this.getCenter());
        this._target.translate(location.x, location.y);
    }
}

