/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.sikuli.script.natives.Mat;
import org.sikuli.script.natives.Vision;

public class OpenCV {
    public static BufferedImage createBufferedImage(int n, int n2) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[]{8, 8, 8, 8};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
        SampleModel sampleModel = ((ColorModel)componentColorModel).createCompatibleSampleModel(n, n2);
        DataBufferByte dataBufferByte = new DataBufferByte(n * n2 * 4);
        WritableRaster writableRaster = WritableRaster.createWritableRaster(sampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    public static byte[] convertBufferedImageToByteArray(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = OpenCV.createBufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return ((DataBufferByte)bufferedImage2.getRaster().getDataBuffer()).getData();
    }

    public static Mat convertBufferedImageToMat(BufferedImage bufferedImage) {
        byte[] byArray = OpenCV.convertBufferedImageToByteArray(bufferedImage);
        return Vision.createMat(bufferedImage.getHeight(), bufferedImage.getWidth(), byArray);
    }
}

