/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Location;

public class Pattern {
    String imgURL = null;
    float similarity = 0.7f;
    BufferedImage image;
    int dx = 0;
    int dy = 0;

    public Pattern() {
    }

    public Pattern(Pattern pattern) {
        this.imgURL = pattern.imgURL;
        this.similarity = pattern.similarity;
        this.dx = pattern.dx;
        this.dy = pattern.dy;
    }

    public Pattern(String string) {
        this.imgURL = string;
    }

    public Pattern(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public Pattern similar(float f) {
        Pattern pattern = new Pattern(this);
        pattern.similarity = f;
        return pattern;
    }

    public Pattern exact() {
        Pattern pattern = new Pattern(this);
        pattern.similarity = 1.0f;
        return pattern;
    }

    public Pattern targetOffset(int n, int n2) {
        Pattern pattern = new Pattern(this);
        pattern.dx = n;
        pattern.dy = n2;
        return pattern;
    }

    public String toString() {
        String string = "Pattern(\"" + this.imgURL + "\")";
        string = string + ".similar(" + this.similarity + ")";
        if (this.dx != 0 || this.dy != 0) {
            string = string + ".targetOffset(" + this.dx + "," + this.dy + ")";
        }
        return string;
    }

    public Location getTargetOffset() {
        return new Location(this.dx, this.dy);
    }

    public String getFilename() {
        return this.imgURL;
    }

    public BufferedImage getImage() throws IOException {
        if (this.image == null) {
            ImageLocator imageLocator = new ImageLocator();
            String string = imageLocator.locate(this.getFilename());
            this.image = ImageIO.read(new File(string));
        }
        return this.image;
    }
}

