/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.sikuli.script.CapturePrompt;
import org.sikuli.script.Debug;
import org.sikuli.script.DesktopRobot;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Observer;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenHighlighter;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.Subject;

public class Screen
extends Region
implements Observer,
IScreen {
    protected GraphicsDevice _curGD;
    protected int _curID = 0;
    protected static int _primaryScreen = -1;
    protected boolean _waitPrompt;
    protected CapturePrompt _prompt;
    protected ScreenHighlighter _overlay;
    static GraphicsDevice[] _gdev;
    static GraphicsEnvironment _genv;
    static IRobot[] _robots;

    @Override
    public Region newRegion(Rectangle rectangle) {
        return Region.create(rectangle, this);
    }

    private static void initRobots() {
        try {
            _robots = new DesktopRobot[_gdev.length];
            for (int i = 0; i < _gdev.length; ++i) {
                Screen._robots[i] = new DesktopRobot(_gdev[i]);
                _robots[i].setAutoDelay(10);
            }
        }
        catch (AWTException aWTException) {
            Debug.error("Can't initiate Java Robot: " + aWTException, new Object[0]);
        }
    }

    public static int getNumberScreens() {
        return _gdev.length;
    }

    public static IRobot getRobot(int n) {
        return _robots[n];
    }

    public static int getPrimaryId() {
        if (_primaryScreen < 0) {
            _primaryScreen = 0;
            for (int i = 0; i < Screen.getNumberScreens(); ++i) {
                Rectangle rectangle = Screen.getBounds(i);
                if (rectangle.x != 0 || rectangle.y != 0) continue;
                _primaryScreen = i;
                break;
            }
        }
        return _primaryScreen;
    }

    @Override
    public IRobot getRobot() {
        return _robots[Screen.getPrimaryId()];
    }

    public GraphicsDevice getGraphicsDevice() {
        return this._curGD;
    }

    public static Rectangle getBounds(int n) {
        return _gdev[n].getDefaultConfiguration().getBounds();
    }

    @Override
    public Rectangle getBounds() {
        return this._curGD.getDefaultConfiguration().getBounds();
    }

    public int getID() {
        return this._curID;
    }

    public Screen(int n) {
        if (n < _gdev.length) {
            this._curGD = _gdev[n];
            this._curID = n;
        } else {
            this.initGD();
        }
        this.initBounds();
    }

    protected void initBounds() {
        Rectangle rectangle = this.getBounds();
        this.init((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), this);
        this._overlay = new ScreenHighlighter(this);
    }

    private void initGD() {
        this._curGD = _genv.getDefaultScreenDevice();
        for (int i = 0; i < _gdev.length; ++i) {
            if (_gdev[i] != this._curGD) continue;
            this._curID = i;
        }
    }

    public Screen() {
        this.initGD();
        this.initBounds();
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getBounds());
    }

    @Override
    public ScreenImage capture(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        return this.capture(rectangle);
    }

    @Override
    public ScreenImage capture(Rectangle rectangle) {
        Debug.log(5, "capture: " + rectangle, new Object[0]);
        Rectangle rectangle2 = this.getBounds();
        rectangle.x -= rectangle2.x;
        rectangle.y -= rectangle2.y;
        ScreenImage screenImage = _robots[this._curID].captureScreen(rectangle);
        screenImage.x += rectangle2.x;
        screenImage.y += rectangle2.y;
        return screenImage;
    }

    @Override
    public ScreenImage capture(Region region) {
        return this.capture(region.getROI());
    }

    public ScreenImage userCapture() {
        return this.userCapture("Select a region on the screen");
    }

    public ScreenImage userCapture(final String string) {
        this._waitPrompt = true;
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                Screen.this._prompt = new CapturePrompt(Screen.this, Screen.this);
                Screen.this._prompt.prompt(string);
            }
        };
        thread2.start();
        try {
            int n = 0;
            while (this._waitPrompt) {
                Thread.sleep(100L);
                if (n++ <= 1000) continue;
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        ScreenImage screenImage = this._prompt.getSelection();
        this._prompt.close();
        return screenImage;
    }

    @Override
    public void update(Subject subject) {
        this._waitPrompt = false;
    }

    public Region selectRegion() {
        return this.selectRegion("Select a region on the screen");
    }

    public Region selectRegion(String string) {
        ScreenImage screenImage = this.userCapture(string);
        if (screenImage == null) {
            return null;
        }
        Rectangle rectangle = screenImage.getROI();
        return Region.create((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    @Override
    public void showMove(Location location) {
        this.showTarget(location);
    }

    @Override
    public void showClick(Location location) {
        this.showTarget(location);
    }

    @Override
    public void showTarget(Location location) {
        this.showTarget(location, Settings.SlowMotionDelay);
    }

    public void showTarget(Location location, double d) {
        if (Settings.ShowActions) {
            this._overlay.showTarget(location, (float)d);
        }
    }

    @Override
    public void showDropTarget(Location location) {
        if (Settings.ShowActions) {
            this._overlay.showDropTarget(location, Settings.SlowMotionDelay);
        }
    }

    boolean useFullscreen() {
        return false;
    }

    @Override
    public String toString() {
        Rectangle rectangle = this.getBounds();
        return String.format("Screen(%d)[%d,%d %dx%d] E:%s, T:%.1f", this._curID, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), this._throwException ? "Y" : "N", this._autoWaitTimeout);
    }

    static {
        _genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        _gdev = _genv.getScreenDevices();
        Screen.initRobots();
    }
}

