/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.sikuli.script.Animator;
import org.sikuli.script.Debug;
import org.sikuli.script.Env;
import org.sikuli.script.Location;
import org.sikuli.script.OS;
import org.sikuli.script.OutQuarticEase;
import org.sikuli.script.PulseAnimator;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.StopExtention;
import org.sikuli.script.TimeBasedAnimator;
import org.sikuli.script.TransparentWindow;

public class ScreenHighlighter
extends TransparentWindow
implements MouseListener {
    static Color _overlayColor = new Color(0.0f, 0.0f, 0.0f, 0.6f);
    static Color _transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    static Color _targetColor = new Color(1.0f, 0.0f, 0.0f, 0.7f);
    static final int TARGET_SIZE = 80;
    static final int DRAGGING_TIME = 200;
    static int MARGIN = 20;
    static Set<ScreenHighlighter> _opened = new HashSet<ScreenHighlighter>();
    Screen _scr;
    VizMode _mode = null;
    BufferedImage _screen = null;
    BufferedImage _darker_screen = null;
    int srcx;
    int srcy;
    int destx;
    int desty;
    Location _lastTarget;
    boolean _borderOnly = false;
    boolean _native_transparent = false;
    boolean _double_buffered = false;
    Animator _anim;
    BasicStroke _StrokeCross = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    BasicStroke _StrokeBorder = new BasicStroke(3.0f);
    BufferedImage bi = null;
    Animator _aniX;
    Animator _aniY;

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispose();
    }

    private void closeAfter(float f) {
        try {
            Thread.sleep((int)f * 1000);
        }
        catch (InterruptedException interruptedException) {
            this.close();
            interruptedException.printStackTrace();
        }
        this.close();
    }

    private void captureScreen(int n, int n2, int n3, int n4) {
        ScreenImage screenImage = this._scr.capture(n, n2, n3, n4);
        this._screen = screenImage.getImage();
        float f = 0.6f;
        RescaleOp rescaleOp = new RescaleOp(f, 0.0f, null);
        this._darker_screen = rescaleOp.filter(this._screen, null);
    }

    private void drawCircle(int n, int n2, int n3, Graphics graphics) {
        graphics.drawOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
    }

    private void drawDragDrop(Graphics2D graphics2D) {
        if (this._aniX.running()) {
            graphics2D.setColor(_targetColor);
            graphics2D.setStroke(this._StrokeBorder);
            int n = (int)this._aniX.step();
            int n2 = (int)this._aniY.step();
            graphics2D.drawLine(this.srcx, this.srcy, n, n2);
            this.drawCircle(this.srcx, this.srcy, 5, graphics2D);
            this.repaint();
        }
    }

    private void drawTarget(Graphics2D graphics2D) {
        int n = (this.srcx + this.destx) / 2;
        int n2 = (this.srcy + this.desty) / 2;
        if (this._anim.running()) {
            graphics2D.setColor(_targetColor);
            graphics2D.setStroke(this._StrokeBorder);
            int n3 = (int)this._anim.step();
            int n4 = n3 == 0 ? 0 : n3 - 5;
            this.drawCircle(n, n2, n3, graphics2D);
            this.drawCircle(n, n2, n4, graphics2D);
            this.repaint();
        }
    }

    private void drawBorder(Graphics2D graphics2D) {
        graphics2D.setColor(_targetColor);
        graphics2D.setStroke(this._StrokeBorder);
        int n = (int)this._StrokeBorder.getLineWidth();
        graphics2D.drawRect(n / 2, n / 2, this.getWidth() - n, this.getHeight() - n);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._native_transparent || this._screen != null) {
            if (this.bi == null || this.bi.getWidth(this) != this.getWidth() || this.bi.getHeight(this) != this.getHeight()) {
                this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            }
            Graphics2D graphics2D = this.bi.createGraphics();
            Graphics2D graphics2D2 = this._double_buffered ? graphics2D : (Graphics2D)graphics;
            graphics2D2.setComposite(AlphaComposite.getInstance(1, 0.0f));
            graphics2D2.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this._borderOnly) {
                if (!this._native_transparent) {
                    graphics2D2.drawImage((Image)this._screen, 0, 0, this);
                }
                this.drawBorder(graphics2D2);
            } else {
                if (!this._native_transparent) {
                    graphics2D2.drawImage((Image)this._screen, 0, 0, this);
                }
                switch (this._mode) {
                    case ONE_TARGET: {
                        this.drawTarget(graphics2D2);
                        break;
                    }
                    case DRAG_DROP: {
                        this.drawDragDrop(graphics2D2);
                    }
                }
            }
            if (this._double_buffered) {
                ((Graphics2D)graphics).drawImage((Image)this.bi, 0, 0, this);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    void init() {
        _opened.add(this);
        if (Env.getOS() == OS.MAC) {
            this._native_transparent = true;
        }
        if (Env.getOS() == OS.WINDOWS) {
            this._native_transparent = true;
            Env.getOSUtil().setWindowOpaque(this, false);
        }
        if (Env.getOS() == OS.LINUX) {
            this._double_buffered = true;
        }
        if (this._native_transparent) {
            this.setBackground(_transparentColor);
        }
        this.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        ((JPanel)this.getContentPane()).setDoubleBuffered(true);
        this.addMouseListener(this);
    }

    @Override
    public void close() {
        this.setVisible(false);
        _opened.remove(this);
        this.dispose();
    }

    public static void closeAll() {
        Debug.log(3, "close all ScreenHighlighter", new Object[0]);
        for (ScreenHighlighter screenHighlighter : _opened) {
            if (!screenHighlighter.isVisible()) continue;
            screenHighlighter.setVisible(false);
            screenHighlighter.dispose();
        }
        _opened.clear();
    }

    public void showDragDrop(int n, int n2, int n3, int n4, float f) {
        this._mode = VizMode.DRAG_DROP;
        int n5 = n < n3 ? n : n3;
        int n6 = n2 < n4 ? n2 : n4;
        int n7 = n > n3 ? n : n3;
        int n8 = n2 > n4 ? n2 : n4;
        this.srcx = n - n5 + MARGIN;
        this.srcy = n2 - n6 + MARGIN;
        this.destx = n3 - n5 + MARGIN;
        this.desty = n4 - n6 + MARGIN;
        this._aniX = new TimeBasedAnimator(new StopExtention(new OutQuarticEase(this.srcx, this.destx, 200L), (long)(1000.0f * f)));
        this._aniY = new TimeBasedAnimator(new StopExtention(new OutQuarticEase(this.srcy, this.desty, 200L), (long)(1000.0f * f)));
        this.showWindow(n5 - MARGIN, n6 - MARGIN, n7 - n5 + 2 * MARGIN, n8 - n6 + 2 * MARGIN, f);
    }

    public void showDropTarget(Location location, float f) {
        this.showDragDrop(this._lastTarget.x, this._lastTarget.y, location.x, location.y, f);
    }

    public void highlight(Region region) {
        Region region2;
        if (Env.getOS() == OS.LINUX) {
            Debug.error("highlight does not work on Linux.", new Object[0]);
            return;
        }
        this._borderOnly = true;
        if (this._native_transparent) {
            region2 = region;
        } else {
            region2 = new Region(region);
            region2.setROI(new Rectangle(region.x - 3, region.y - 3, region.w + 6, region.h + 6));
            this.captureScreen(region2.x, region2.y, region2.w, region2.h);
        }
        this.setLocation(region2.x, region2.y);
        this.setSize(region2.w, region2.h);
        this.setBackground(_transparentColor);
        this.setVisible(true);
        this.toFront();
    }

    public void highlight(Region region, float f) {
        this.highlight(region);
        this.closeAfter(f);
    }

    public void showTarget(Location location, float f) {
        this._mode = VizMode.ONE_TARGET;
        int n = location.x - 40;
        int n2 = location.y - 40;
        this._lastTarget = location;
        Debug.log(1, "showTarget " + n + " " + n2 + " " + 80 + " " + 80, new Object[0]);
        this.srcx = 0;
        this.destx = 80;
        this.srcy = 0;
        this.desty = 80;
        this._anim = new PulseAnimator(35.0f, 0.0f, 350L, (long)(f * 1000.0f));
        this.showWindow(n, n2, 80, 80, f);
    }

    private void showWindow(int n, int n2, int n3, int n4, float f) {
        if (!this._native_transparent) {
            this.captureScreen(n, n2, n3, n4);
        }
        this.setLocation(n, n2);
        this.setSize(n3, n4);
        this.setVisible(true);
        this.toFront();
        this.closeAfter(f);
    }

    public ScreenHighlighter(Screen screen) {
        this._scr = screen;
        this.init();
        this.setVisible(false);
        this.setAlwaysOnTop(true);
    }

    @Override
    public void toFront() {
        if (Env.getOS() == OS.MAC) {
            Env.getOSUtil().bringWindowToFront(this, true);
        }
        super.toFront();
    }

    static enum VizMode {
        ONE_TARGET,
        DRAG_DROP;

    }
}

