/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ScreenImage {
    public int x;
    public int y;
    public int w;
    public int h;
    protected Rectangle _roi;
    protected BufferedImage _img;
    protected String _filename = null;

    public ScreenImage(Rectangle rectangle, BufferedImage bufferedImage) {
        this._img = bufferedImage;
        this._roi = rectangle;
        this.x = (int)rectangle.getX();
        this.y = (int)rectangle.getY();
        this.w = (int)rectangle.getWidth();
        this.h = (int)rectangle.getHeight();
    }

    public String getFilename() throws IOException {
        if (this._filename == null) {
            File file = File.createTempFile("sikuli-scr-", ".png");
            file.deleteOnExit();
            ImageIO.write((RenderedImage)this._img, "png", file);
            this._filename = file.getAbsolutePath();
        }
        return this._filename;
    }

    public BufferedImage getImage() {
        return this._img;
    }

    public Rectangle getROI() {
        return this._roi;
    }
}

