/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.python.util.PythonInterpreter;
import org.sikuli.script.ScreenHighlighter;
import org.sikuli.script.Settings;
import org.sikuli.script.Util;

public class ScriptRunner {
    private static ScriptRunner _instance = null;
    private List<String> _headers;
    private List<String> _tmp_headers;
    private PythonInterpreter py;

    public static ScriptRunner getInstance(String[] stringArray) {
        if (_instance == null) {
            _instance = new ScriptRunner(stringArray);
        }
        return _instance;
    }

    public ScriptRunner(String[] stringArray) {
        this.init(stringArray);
    }

    void init(String[] stringArray) {
        PythonInterpreter.initialize(System.getProperties(), null, stringArray);
        this.py = new PythonInterpreter();
        String[] stringArray2 = new String[]{"# coding=utf-8", "from __future__ import with_statement", "from sikuli import *", "setThrowException(True)", "setShowActions(False)"};
        this._headers = new LinkedList<String>(Arrays.asList(stringArray2));
        this._tmp_headers = new LinkedList<String>();
    }

    public void addTempHeader(String string) {
        this._tmp_headers.add(string);
    }

    public PythonInterpreter getPythonInterpreter() {
        return this.py;
    }

    public void runPython(String string, File file) throws IOException {
        String string22;
        this.addTempHeader("addModPath(\"" + string + "\")");
        this.addTempHeader("addModPath(\"" + Util.getParentPath(string) + "\")");
        this.addTempHeader("if len(sys.argv)==0 or '" + string + "' != sys.argv[0]: sys.argv.insert(0, '" + string + "')");
        for (String string22 : this._headers) {
            this.py.exec(string22);
        }
        for (String string22 : this._tmp_headers) {
            this.py.exec(string22);
        }
        Settings.BundlePath = string22 = new File(string).getAbsolutePath();
        this.py.execfile(file.getAbsolutePath());
        this._tmp_headers.clear();
        try {
            this.py.exec("exit(0)");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.py.cleanup();
    }

    public void close() {
        ScreenHighlighter.closeAll();
    }

    public void runPythonAsync(final String string) throws IOException {
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    ScriptRunner.this.runPython(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(thread2);
    }

    public void runPython(String string) throws IOException {
        File file = this.getPyFrom(string);
        this.runPython(string, file);
    }

    private File getPyFrom(String string) throws IOException {
        String string2 = new File(string).getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        return new File(string + "/" + string3 + ".py");
    }
}

