/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerTokenServicesConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.util.CollectionUtils;

@Configuration
public class UserInfoRestTemplateFactory {
    private static final AuthorizationCodeResourceDetails DEFAULT_RESOURCE_DETAILS;
    private final List<UserInfoRestTemplateCustomizer> customizers;
    private final OAuth2ProtectedResourceDetails details;
    private final OAuth2ClientContext oauth2ClientContext;
    private OAuth2RestTemplate template;

    public UserInfoRestTemplateFactory(ObjectProvider<List<UserInfoRestTemplateCustomizer>> customizersProvider, ObjectProvider<OAuth2ProtectedResourceDetails> detailsProvider, ObjectProvider<OAuth2ClientContext> oauth2ClientContextProvider) {
        this.customizers = (List)customizersProvider.getIfAvailable();
        this.details = (OAuth2ProtectedResourceDetails)detailsProvider.getIfAvailable();
        this.oauth2ClientContext = (OAuth2ClientContext)oauth2ClientContextProvider.getIfAvailable();
    }

    public OAuth2RestTemplate getUserInfoRestTemplate() {
        if (this.template == null) {
            this.template = this.getTemplate((OAuth2ProtectedResourceDetails)(this.details == null ? DEFAULT_RESOURCE_DETAILS : this.details));
            this.template.getInterceptors().add(new ResourceServerTokenServicesConfiguration.AcceptJsonRequestInterceptor());
            AuthorizationCodeAccessTokenProvider accessTokenProvider = new AuthorizationCodeAccessTokenProvider();
            accessTokenProvider.setTokenRequestEnhancer((RequestEnhancer)new ResourceServerTokenServicesConfiguration.AcceptJsonRequestEnhancer());
            this.template.setAccessTokenProvider((AccessTokenProvider)accessTokenProvider);
            if (!CollectionUtils.isEmpty(this.customizers)) {
                AnnotationAwareOrderComparator.sort(this.customizers);
                for (UserInfoRestTemplateCustomizer customizer : this.customizers) {
                    customizer.customize(this.template);
                }
            }
        }
        return this.template;
    }

    private OAuth2RestTemplate getTemplate(OAuth2ProtectedResourceDetails details) {
        if (this.oauth2ClientContext == null) {
            return new OAuth2RestTemplate(details);
        }
        return new OAuth2RestTemplate(details, this.oauth2ClientContext);
    }

    static {
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setClientId("<N/A>");
        details.setUserAuthorizationUri("Not a URI because there is no client");
        details.setAccessTokenUri("Not a URI because there is no client");
        DEFAULT_RESOURCE_DETAILS = details;
    }
}

