/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.spring.cache.CacheBuilder;
import com.couchbase.client.spring.cache.CouchbaseCacheManager;
import java.time.Duration;
import java.util.List;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Bucket.class, CouchbaseCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@ConditionalOnSingleCandidate(value=Bucket.class)
@Conditional(value={CacheCondition.class})
public class CouchbaseCacheConfiguration {
    private final CacheProperties cacheProperties;
    private final CacheManagerCustomizers customizers;
    private final Bucket bucket;

    public CouchbaseCacheConfiguration(CacheProperties cacheProperties, CacheManagerCustomizers customizers, Bucket bucket) {
        this.cacheProperties = cacheProperties;
        this.customizers = customizers;
        this.bucket = bucket;
    }

    @Bean
    public CouchbaseCacheManager cacheManager() {
        List<String> cacheNames = this.cacheProperties.getCacheNames();
        CacheBuilder builder = CacheBuilder.newInstance((Bucket)this.bucket);
        CacheProperties.Couchbase couchbase = this.cacheProperties.getCouchbase();
        PropertyMapper.get().from(couchbase::getExpiration).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((CacheBuilder)builder).withExpiration(arg_0));
        String[] names = StringUtils.toStringArray(cacheNames);
        CouchbaseCacheManager cacheManager = new CouchbaseCacheManager(builder, names);
        return this.customizers.customize(cacheManager);
    }
}

