/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.env;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.devtools.logger.DevToolsLogFactory;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.boot.devtools.system.DevToolsEnablementDeducer;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.log.LogMessage;
import org.springframework.util.ClassUtils;

@Order(value=0x7FFFFFFF)
public class DevToolsPropertyDefaultsPostProcessor
implements EnvironmentPostProcessor {
    private static final Log logger = DevToolsLogFactory.getLog(DevToolsPropertyDefaultsPostProcessor.class);
    private static final String ENABLED = "spring.devtools.add-properties";
    private static final String WEB_LOGGING = "logging.level.web";
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"org.springframework.web.context.ConfigurableWebEnvironment", "org.springframework.boot.web.reactive.context.ConfigurableReactiveWebEnvironment"};
    private static final Map<String, Object> PROPERTIES;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (DevToolsEnablementDeducer.shouldEnable(Thread.currentThread()) && this.isLocalApplication(environment)) {
            if (this.canAddProperties((Environment)environment)) {
                logger.info((Object)LogMessage.format((String)"Devtools property defaults active! Set '%s' to 'false' to disable", (Object)ENABLED));
                HashMap<String, Object> properties = new HashMap<String, Object>(PROPERTIES);
                properties.putAll(this.getResourceProperties((Environment)environment));
                environment.getPropertySources().addLast((PropertySource)new MapPropertySource("devtools", properties));
            }
            if (this.isWebApplication((Environment)environment) && !environment.containsProperty(WEB_LOGGING)) {
                logger.info((Object)LogMessage.format((String)"For additional web related logging consider setting the '%s' property to 'DEBUG'", (Object)WEB_LOGGING));
            }
        }
    }

    private Map<String, String> getResourceProperties(Environment environment) {
        HashMap<String, String> resourceProperties = new HashMap<String, String>();
        String prefix = this.determineResourcePropertiesPrefix(environment);
        resourceProperties.put(prefix + "cache.period", "0");
        resourceProperties.put(prefix + "chain.cache", "false");
        return resourceProperties;
    }

    private String determineResourcePropertiesPrefix(Environment environment) {
        BindResult result;
        if (ClassUtils.isPresent((String)"org.springframework.boot.autoconfigure.web.ResourceProperties", (ClassLoader)this.getClass().getClassLoader()) && (result = Binder.get((Environment)environment).bind("spring.resources", ResourceProperties.class)).isBound() && ((ResourceProperties)result.get()).hasBeenCustomized()) {
            return "spring.resources.";
        }
        return "spring.web.resources.";
    }

    private boolean isLocalApplication(ConfigurableEnvironment environment) {
        return environment.getPropertySources().get("remoteUrl") == null;
    }

    private boolean canAddProperties(Environment environment) {
        if (((Boolean)environment.getProperty(ENABLED, Boolean.class, (Object)true)).booleanValue()) {
            return this.isRestarterInitialized() || this.isRemoteRestartEnabled(environment);
        }
        return false;
    }

    private boolean isRestarterInitialized() {
        try {
            Restarter restarter = Restarter.getInstance();
            return restarter != null && restarter.getInitialUrls() != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isRemoteRestartEnabled(Environment environment) {
        return environment.containsProperty("spring.devtools.remote.secret");
    }

    private boolean isWebApplication(Environment environment) {
        for (String candidate : WEB_ENVIRONMENT_CLASSES) {
            Class<?> environmentClass = this.resolveClassName(candidate, environment.getClass().getClassLoader());
            if (environmentClass == null || !environmentClass.isInstance(environment)) continue;
            return true;
        }
        return false;
    }

    private Class<?> resolveClassName(String candidate, ClassLoader classLoader) {
        try {
            return ClassUtils.resolveClassName((String)candidate, (ClassLoader)classLoader);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    static {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.thymeleaf.cache", "false");
        properties.put("spring.freemarker.cache", "false");
        properties.put("spring.groovy.template.cache", "false");
        properties.put("spring.mustache.cache", "false");
        properties.put("server.servlet.session.persistent", "true");
        properties.put("spring.h2.console.enabled", "true");
        properties.put("spring.web.resources.cache.period", "0");
        properties.put("spring.web.resources.chain.cache", "false");
        properties.put("spring.template.provider.cache", "false");
        properties.put("spring.mvc.log-resolved-exception", "true");
        properties.put("server.error.include-binding-errors", "ALWAYS");
        properties.put("server.error.include-message", "ALWAYS");
        properties.put("server.error.include-stacktrace", "ALWAYS");
        properties.put("server.servlet.jsp.init-parameters.development", "true");
        properties.put("spring.reactor.debug", "true");
        PROPERTIES = Collections.unmodifiableMap(properties);
    }
}

