/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;

class WebDriverScope
implements Scope {
    public static final String NAME = "webDriver";
    private static final String WEB_DRIVER_CLASS = "org.openqa.selenium.WebDriver";
    private static final String[] BEAN_CLASSES = new String[]{"org.openqa.selenium.WebDriver", "org.springframework.test.web.servlet.htmlunit.webdriver.MockMvcHtmlUnitDriverBuilder"};
    private final Map<String, Object> instances = new HashMap<String, Object>();

    WebDriverScope() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Map<String, Object> map = this.instances;
        synchronized (map) {
            Object instance = this.instances.get(name);
            if (instance == null) {
                instance = objectFactory.getObject();
                this.instances.put(name, instance);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        Map<String, Object> map = this.instances;
        synchronized (map) {
            return this.instances.remove(name);
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reset() {
        boolean reset = false;
        Map<String, Object> map = this.instances;
        synchronized (map) {
            for (Object instance : this.instances.values()) {
                reset = true;
                if (!(instance instanceof WebDriver)) continue;
                ((WebDriver)instance).quit();
            }
            this.instances.clear();
        }
        return reset;
    }

    public static void registerWith(ConfigurableApplicationContext context) {
        if (!ClassUtils.isPresent((String)WEB_DRIVER_CLASS, null)) {
            return;
        }
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory.getRegisteredScope(NAME) == null) {
            beanFactory.registerScope(NAME, (Scope)new WebDriverScope());
        }
        context.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                for (String beanClass : BEAN_CLASSES) {
                    for (String beanName : beanFactory.getBeanNamesForType(ClassUtils.resolveClassName((String)beanClass, null))) {
                        beanFactory.getBeanDefinition(beanName).setScope(WebDriverScope.NAME);
                    }
                }
            }
        });
    }

    public static WebDriverScope getFrom(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            Scope scope = ((ConfigurableApplicationContext)context).getBeanFactory().getRegisteredScope(NAME);
            return scope instanceof WebDriverScope ? (WebDriverScope)scope : null;
        }
        return null;
    }
}

