/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.MockitoAopProxyTargetInterceptor;
import org.springframework.boot.test.mock.mockito.MockitoBeans;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.boot.test.mock.mockito.SpyDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.Conventions;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MockitoPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanClassLoaderAware,
BeanFactoryAware,
BeanFactoryPostProcessor,
Ordered {
    private static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";
    private static final String BEAN_NAME = MockitoPostProcessor.class.getName();
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"configurationClass");
    private final Set<Definition> definitions;
    private ClassLoader classLoader;
    private BeanFactory beanFactory;
    private final BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();
    private final MockitoBeans mockitoBeans = new MockitoBeans();
    private Map<Definition, String> beanNameRegistry = new HashMap<Definition, String>();
    private Map<Field, RegisteredField> fieldRegistry = new HashMap<Field, RegisteredField>();
    private Map<String, SpyDefinition> spies = new HashMap<String, SpyDefinition>();

    public MockitoPostProcessor(Set<Definition> definitions) {
        this.definitions = definitions;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"Mock beans can only be used with a ConfigurableListableBeanFactory");
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory, (String)"@MockBean can only be used on bean factories that implement BeanDefinitionRegistry");
        this.postProcessBeanFactory(beanFactory, (BeanDefinitionRegistry)beanFactory);
    }

    private void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        beanFactory.registerSingleton(MockitoBeans.class.getName(), (Object)this.mockitoBeans);
        DefinitionsParser parser = new DefinitionsParser(this.definitions);
        for (Class<?> configurationClass : this.getConfigurationClasses(beanFactory)) {
            parser.parse(configurationClass);
        }
        Set<Definition> definitions = parser.getDefinitions();
        for (Definition definition : definitions) {
            Field field = parser.getField(definition);
            this.register(beanFactory, registry, definition, field);
        }
    }

    private Set<Class<?>> getConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashSet configurationClasses = new LinkedHashSet();
        for (BeanDefinition beanDefinition : this.getConfigurationBeanDefinitions(beanFactory).values()) {
            configurationClasses.add(ClassUtils.resolveClassName((String)beanDefinition.getBeanClassName(), (ClassLoader)this.classLoader));
        }
        return configurationClasses;
    }

    private Map<String, BeanDefinition> getConfigurationBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, BeanDefinition> definitions = new LinkedHashMap<String, BeanDefinition>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            if (definition.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE) == null) continue;
            definitions.put(beanName, definition);
        }
        return definitions;
    }

    private void register(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, Definition definition, Field field) {
        if (definition instanceof MockDefinition) {
            this.registerMock(beanFactory, registry, (MockDefinition)definition, field);
        } else if (definition instanceof SpyDefinition) {
            this.registerSpy(beanFactory, registry, (SpyDefinition)definition, field);
        }
    }

    private void registerMock(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition definition, Field field) {
        RootBeanDefinition beanDefinition = this.createBeanDefinition(definition);
        String beanName = this.getBeanName(beanFactory, registry, definition, beanDefinition);
        beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)beanName);
        if (registry.containsBeanDefinition(beanName)) {
            registry.removeBeanDefinition(beanName);
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        Object mock = this.createMock(definition, beanName);
        beanFactory.registerSingleton(beanName, mock);
        this.mockitoBeans.add(mock);
        this.beanNameRegistry.put(definition, beanName);
        if (field != null) {
            this.fieldRegistry.put(field, new RegisteredField(definition, beanName));
        }
    }

    private RootBeanDefinition createBeanDefinition(MockDefinition mockDefinition) {
        RootBeanDefinition definition = new RootBeanDefinition(mockDefinition.getTypeToMock().resolve());
        definition.setTargetType(mockDefinition.getTypeToMock());
        definition.setFactoryBeanName(BEAN_NAME);
        definition.setFactoryMethodName("createMock");
        definition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)mockDefinition);
        if (mockDefinition.getQualifier() != null) {
            mockDefinition.getQualifier().applyTo(definition);
        }
        return definition;
    }

    protected final Object createMock(MockDefinition mockDefinition, String name) {
        return mockDefinition.createMock(name + " bean");
    }

    private String getBeanName(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition mockDefinition, RootBeanDefinition beanDefinition) {
        if (StringUtils.hasLength((String)mockDefinition.getName())) {
            return mockDefinition.getName();
        }
        Set<String> existingBeans = this.findCandidateBeans(beanFactory, mockDefinition);
        if (existingBeans.isEmpty()) {
            return this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry);
        }
        if (existingBeans.size() == 1) {
            return existingBeans.iterator().next();
        }
        throw new IllegalStateException("Unable to register mock bean " + mockDefinition.getTypeToMock() + " expected a single matching bean to replace but found " + existingBeans);
    }

    private void registerSpy(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, SpyDefinition definition, Field field) {
        Object[] existingBeans = this.getExistingBeans(beanFactory, definition.getTypeToSpy());
        if (ObjectUtils.isEmpty((Object[])existingBeans)) {
            this.createSpy(registry, definition, field);
        } else {
            this.registerSpies(definition, field, (String[])existingBeans);
        }
    }

    private Set<String> findCandidateBeans(ConfigurableListableBeanFactory beanFactory, MockDefinition mockDefinition) {
        QualifierDefinition qualifier = mockDefinition.getQualifier();
        TreeSet<String> candidates = new TreeSet<String>();
        for (String candidate : this.getExistingBeans(beanFactory, mockDefinition.getTypeToMock())) {
            if (qualifier != null && !qualifier.matches(beanFactory, candidate)) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    private String[] getExistingBeans(ConfigurableListableBeanFactory beanFactory, ResolvableType type) {
        LinkedHashSet<String> beans = new LinkedHashSet<String>(Arrays.asList(beanFactory.getBeanNamesForType(type)));
        String resolvedTypeName = type.resolve(Object.class).getName();
        for (String beanName : beanFactory.getBeanNamesForType(FactoryBean.class)) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName = BeanFactoryUtils.transformedBeanName((String)beanName));
            if (!resolvedTypeName.equals(beanDefinition.getAttribute(FACTORY_BEAN_OBJECT_TYPE))) continue;
            beans.add(beanName);
        }
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            if (!this.isScopedTarget((String)iterator.next())) continue;
            iterator.remove();
        }
        return beans.toArray(new String[beans.size()]);
    }

    private boolean isScopedTarget(String beanName) {
        try {
            return ScopedProxyUtils.isScopedTarget((String)beanName);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void createSpy(BeanDefinitionRegistry registry, SpyDefinition definition, Field field) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(definition.getTypeToSpy().resolve());
        String beanName = this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        this.registerSpy(definition, field, beanName);
    }

    private void registerSpies(SpyDefinition definition, Field field, String[] existingBeans) {
        Assert.state((field == null || existingBeans.length == 1 ? 1 : 0) != 0, (String)("Unable to register spy bean " + definition.getTypeToSpy() + " expected a single existing bean to replace but found " + new TreeSet<String>(Arrays.asList(existingBeans))));
        for (String beanName : existingBeans) {
            this.registerSpy(definition, field, beanName);
        }
    }

    private void registerSpy(SpyDefinition definition, Field field, String beanName) {
        this.spies.put(beanName, definition);
        this.beanNameRegistry.put(definition, beanName);
        if (field != null) {
            this.fieldRegistry.put(field, new RegisteredField(definition, beanName));
        }
    }

    protected Object createSpyIfNecessary(Object bean, String beanName) throws BeansException {
        SpyDefinition definition = this.spies.get(beanName);
        if (definition != null) {
            bean = definition.createSpy(beanName, bean);
        }
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                MockitoPostProcessor.this.postProcessField(bean, field);
            }
        });
        return pvs;
    }

    private void postProcessField(Object bean, Field field) {
        RegisteredField registered = this.fieldRegistry.get(field);
        if (registered != null && StringUtils.hasLength((String)registered.getBeanName())) {
            this.inject(field, bean, registered.getBeanName(), registered.getDefinition());
        }
    }

    void inject(Field field, Object target, Definition definition) {
        String beanName = this.beanNameRegistry.get(definition);
        Assert.state((boolean)StringUtils.hasLength((String)beanName), (String)("No bean found for definition " + definition));
        this.inject(field, target, beanName, definition);
    }

    private void inject(Field field, Object target, String beanName, Definition definition) {
        try {
            field.setAccessible(true);
            Assert.state((ReflectionUtils.getField((Field)field, (Object)target) == null ? 1 : 0) != 0, (String)("The field " + field + " cannot have an existing value"));
            Object bean = this.beanFactory.getBean(beanName, field.getType());
            if (definition.isProxyTargetAware() && this.isAopProxy(bean)) {
                MockitoAopProxyTargetInterceptor.applyTo(bean);
            }
            ReflectionUtils.setField((Field)field, (Object)target, (Object)bean);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Could not inject field: " + field, ex);
        }
    }

    private boolean isAopProxy(Object object) {
        try {
            return AopUtils.isAopProxy((Object)object);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public static void register(BeanDefinitionRegistry registry) {
        MockitoPostProcessor.register(registry, null);
    }

    public static void register(BeanDefinitionRegistry registry, Set<Definition> definitions) {
        MockitoPostProcessor.register(registry, MockitoPostProcessor.class, definitions);
    }

    public static void register(BeanDefinitionRegistry registry, Class<? extends MockitoPostProcessor> postProcessor, Set<Definition> definitions) {
        SpyPostProcessor.register(registry);
        BeanDefinition definition = MockitoPostProcessor.getOrAddBeanDefinition(registry, postProcessor);
        ConstructorArgumentValues.ValueHolder constructorArg = definition.getConstructorArgumentValues().getIndexedArgumentValue(0, Set.class);
        Set existing = (Set)constructorArg.getValue();
        if (definitions != null) {
            existing.addAll(definitions);
        }
    }

    private static BeanDefinition getOrAddBeanDefinition(BeanDefinitionRegistry registry, Class<? extends MockitoPostProcessor> postProcessor) {
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            RootBeanDefinition definition = new RootBeanDefinition(postProcessor);
            definition.setRole(2);
            ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
            constructorArguments.addIndexedArgumentValue(0, new LinkedHashSet());
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
            return definition;
        }
        return registry.getBeanDefinition(BEAN_NAME);
    }

    private static class RegisteredField {
        private final Definition definition;
        private final String beanName;

        RegisteredField(Definition definition, String beanName) {
            this.definition = definition;
            this.beanName = beanName;
        }

        public Definition getDefinition() {
            return this.definition;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }

    static class SpyPostProcessor
    extends InstantiationAwareBeanPostProcessorAdapter
    implements PriorityOrdered {
        private static final String BEAN_NAME = SpyPostProcessor.class.getName();
        private final MockitoPostProcessor mockitoPostProcessor;

        SpyPostProcessor(MockitoPostProcessor mockitoPostProcessor) {
            this.mockitoPostProcessor = mockitoPostProcessor;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
            return this.createSpyIfNecessary(bean, beanName);
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return this.createSpyIfNecessary(bean, beanName);
        }

        private Object createSpyIfNecessary(Object bean, String beanName) {
            return this.mockitoPostProcessor.createSpyIfNecessary(bean, beanName);
        }

        public static void register(BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                RootBeanDefinition definition = new RootBeanDefinition(SpyPostProcessor.class);
                definition.setRole(2);
                ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
                constructorArguments.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(BEAN_NAME));
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
            }
        }
    }
}

