/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.reactive.server;

import java.util.List;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.reactive.server.WebTestClientContextCustomizer;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.util.ClassUtils;

class WebTestClientContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final String WEB_TEST_CLIENT_CLASS = "org.springframework.web.reactive.function.client.WebClient";

    WebTestClientContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        MergedAnnotations annotations = MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS);
        if (this.isWebClientPresent() && annotations.isPresent(SpringBootTest.class)) {
            return new WebTestClientContextCustomizer();
        }
        return null;
    }

    private boolean isWebClientPresent() {
        return ClassUtils.isPresent((String)WEB_TEST_CLIENT_CLASS, (ClassLoader)this.getClass().getClassLoader());
    }
}

