/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.health.model.HealthService;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public final class ConsulServerUtils {
    private static final Log log = LogFactory.getLog(ConsulServerUtils.class);

    private ConsulServerUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static String findHost(HealthService healthService) {
        HealthService.Service service = healthService.getService();
        HealthService.Node node = healthService.getNode();
        if (StringUtils.hasText((String)service.getAddress())) {
            return ConsulServerUtils.fixIPv6Address(service.getAddress());
        }
        if (StringUtils.hasText((String)node.getAddress())) {
            return ConsulServerUtils.fixIPv6Address(node.getAddress());
        }
        return node.getNode();
    }

    public static String fixIPv6Address(String address) {
        try {
            InetAddress inetAdr = InetAddress.getByName(address);
            if (inetAdr instanceof Inet6Address) {
                return "[" + inetAdr.getHostName() + "]";
            }
            return address;
        }
        catch (UnknownHostException e) {
            log.debug((Object)("Not InetAddress: " + address + " , resolved as is."));
            return address;
        }
    }

    @Deprecated
    public static Map<String, String> getMetadata(HealthService healthService) {
        return ConsulServerUtils.getMetadata(healthService, true);
    }

    @Deprecated
    public static Map<String, String> getMetadata(HealthService healthService, boolean tagsAsMetadata) {
        if (tagsAsMetadata) {
            return ConsulServerUtils.getMetadata(healthService.getService().getTags());
        }
        return healthService.getService().getMeta();
    }

    @Deprecated
    public static Map<String, String> getMetadata(List<String> tags) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        if (tags != null) {
            block5: for (String tag : tags) {
                String[] parts = StringUtils.delimitedListToStringArray((String)tag, (String)"=");
                switch (parts.length) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        metadata.put(parts[0], parts[0]);
                        continue block5;
                    }
                    case 2: {
                        metadata.put(parts[0], parts[1]);
                        continue block5;
                    }
                }
                Object[] end = Arrays.copyOfRange(parts, 1, parts.length);
                metadata.put(parts[0], StringUtils.arrayToDelimitedString((Object[])end, (String)"="));
            }
        }
        return metadata;
    }
}

