/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaQueryParserSupport;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;
import org.springframework.data.jpa.repository.query.JpqlLexer;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryTransformer;
import org.springframework.lang.Nullable;

class JpqlQueryParser
extends JpaQueryParserSupport {
    JpqlQueryParser(String query) {
        super(query);
    }

    public static ParserRuleContext parseQuery(String query) {
        JpqlLexer lexer = new JpqlLexer((CharStream)CharStreams.fromString((String)query));
        JpqlParser parser = new JpqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        JpqlQueryParser.configureParser(query, lexer, parser);
        return parser.start();
    }

    @Override
    protected ParserRuleContext parse(String query) {
        return JpqlQueryParser.parseQuery(query);
    }

    @Override
    protected List<JpaQueryParsingToken> applySort(ParserRuleContext parsedQuery, Sort sort) {
        return (List)new JpqlQueryTransformer(sort).visit((ParseTree)parsedQuery);
    }

    @Override
    protected List<JpaQueryParsingToken> doCreateCountQuery(ParserRuleContext parsedQuery, @Nullable String countProjection) {
        return (List)new JpqlQueryTransformer(true, countProjection).visit((ParseTree)parsedQuery);
    }

    @Override
    protected String doFindAlias(ParserRuleContext parsedQuery) {
        JpqlQueryTransformer transformVisitor = new JpqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.getAlias();
    }

    @Override
    protected List<JpaQueryParsingToken> doFindProjection(ParserRuleContext parsedQuery) {
        JpqlQueryTransformer transformVisitor = new JpqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.getProjection();
    }

    @Override
    protected boolean doCheckForConstructor(ParserRuleContext parsedQuery) {
        JpqlQueryTransformer transformVisitor = new JpqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.hasConstructorExpression();
    }
}

