/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.google.common.base.Function;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.querydsl.mongodb.AbstractMongodbQuery;
import com.querydsl.mongodb.MongodbSerializer;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbSerializer;

public class SpringDataMongodbQuery<T>
extends AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> {
    private final MongoOperations operations;

    public SpringDataMongodbQuery(MongoOperations operations, Class<? extends T> type) {
        this(operations, type, operations.getCollectionName(type));
    }

    public SpringDataMongodbQuery(final MongoOperations operations, final Class<? extends T> type, String collectionName) {
        super(operations.getCollection(collectionName), new Function<DBObject, T>(){

            public T apply(DBObject input) {
                return operations.getConverter().read(type, input);
            }
        }, (MongodbSerializer)new SpringDataMongodbSerializer(operations.getConverter()));
        this.operations = operations;
    }

    protected DBCollection getCollection(Class<?> type) {
        return this.operations.getCollection(this.operations.getCollectionName(type));
    }
}

