/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.afterinvocation;

import java.util.List;
import org.springframework.security.access.AfterInvocationProvider;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public abstract class AbstractAclProvider
implements AfterInvocationProvider {
    protected final AclService aclService;
    protected Class<?> processDomainObjectClass = Object.class;
    protected ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    protected SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    protected String processConfigAttribute;
    protected final List<Permission> requirePermission;

    public AbstractAclProvider(AclService aclService, String processConfigAttribute, List<Permission> requirePermission) {
        Assert.hasText((String)processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)aclService, (String)"An AclService is mandatory");
        if (requirePermission == null || requirePermission.isEmpty()) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
        this.aclService = aclService;
        this.processConfigAttribute = processConfigAttribute;
        this.requirePermission = requirePermission;
    }

    protected Class<?> getProcessDomainObjectClass() {
        return this.processDomainObjectClass;
    }

    protected boolean hasPermission(Authentication authentication, Object domainObject) {
        ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
        List<Sid> sids = this.sidRetrievalStrategy.getSids(authentication);
        try {
            Acl acl = this.aclService.readAclById(objectIdentity, sids);
            return acl.isGranted(this.requirePermission, sids, false);
        }
        catch (NotFoundException ignore) {
            return false;
        }
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        Assert.notNull((Object)objectIdentityRetrievalStrategy, (String)"ObjectIdentityRetrievalStrategy required");
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    protected void setProcessConfigAttribute(String processConfigAttribute) {
        Assert.hasText((String)processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        this.processConfigAttribute = processConfigAttribute;
    }

    public void setProcessDomainObjectClass(Class<?> processDomainObjectClass) {
        Assert.notNull(processDomainObjectClass, (String)"processDomainObjectClass cannot be set to null");
        this.processDomainObjectClass = processDomainObjectClass;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, (String)"SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public boolean supports(ConfigAttribute attribute) {
        return this.processConfigAttribute.equals(attribute.getAttribute());
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

