/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

public class MockPortalContext
implements PortalContext {
    private final Properties properties = new Properties();
    private final Vector portletModes;
    private final Vector windowStates;

    public MockPortalContext() {
        this.portletModes = new Vector(3);
        this.portletModes.add(PortletMode.VIEW);
        this.portletModes.add(PortletMode.EDIT);
        this.portletModes.add(PortletMode.HELP);
        this.windowStates = new Vector(3);
        this.windowStates.add(WindowState.NORMAL);
        this.windowStates.add(WindowState.MAXIMIZED);
        this.windowStates.add(WindowState.MINIMIZED);
    }

    public MockPortalContext(List supportedPortletModes, List supportedWindowStates) {
        this.portletModes = new Vector(supportedPortletModes);
        this.windowStates = new Vector(supportedWindowStates);
    }

    public String getPortalInfo() {
        return "MockPortal/1.0";
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Enumeration getPropertyNames() {
        return this.properties.propertyNames();
    }

    public Enumeration getSupportedPortletModes() {
        return this.portletModes.elements();
    }

    public Enumeration getSupportedWindowStates() {
        return this.windowStates.elements();
    }
}

