/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.DelegatingServletInputStream;
import org.springframework.mock.web.HeaderValueHolder;
import org.springframework.mock.web.MockAsyncContext;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockRequestDispatcher;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class MockHttpServletRequest
implements HttpServletRequest {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String CHARSET_PREFIX = "charset=";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final ServletInputStream EMPTY_SERVLET_INPUT_STREAM = new DelegatingServletInputStream(StreamUtils.emptyInput());
    private static final BufferedReader EMPTY_BUFFERED_READER = new BufferedReader(new StringReader(""));
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    public static final String DEFAULT_PROTOCOL = "HTTP/1.1";
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 80;
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    private final ServletContext servletContext;
    private boolean active = true;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    @Nullable
    private String characterEncoding;
    @Nullable
    private byte[] content;
    @Nullable
    private String contentType;
    private final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>(16);
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private final List<Locale> locales = new LinkedList<Locale>();
    private boolean secure = false;
    private int remotePort = 80;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private int localPort = 80;
    private boolean asyncStarted = false;
    private boolean asyncSupported = false;
    @Nullable
    private MockAsyncContext asyncContext;
    private DispatcherType dispatcherType = DispatcherType.REQUEST;
    @Nullable
    private String authType;
    @Nullable
    private Cookie[] cookies;
    private final Map<String, HeaderValueHolder> headers = new LinkedCaseInsensitiveMap();
    @Nullable
    private String method;
    @Nullable
    private String pathInfo;
    private String contextPath = "";
    @Nullable
    private String queryString;
    @Nullable
    private String remoteUser;
    private final Set<String> userRoles = new HashSet<String>();
    @Nullable
    private Principal userPrincipal;
    @Nullable
    private String requestedSessionId;
    @Nullable
    private String requestURI;
    private String servletPath = "";
    @Nullable
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;
    private final MultiValueMap<String, Part> parts = new LinkedMultiValueMap();

    public MockHttpServletRequest() {
        this(null, "", "");
    }

    public MockHttpServletRequest(@Nullable String method, @Nullable String requestURI) {
        this(null, method, requestURI);
    }

    public MockHttpServletRequest(@Nullable ServletContext servletContext) {
        this(servletContext, "", "");
    }

    public MockHttpServletRequest(@Nullable ServletContext servletContext, @Nullable String method, @Nullable String requestURI) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.method = method;
        this.requestURI = requestURI;
        this.locales.add(Locale.ENGLISH);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isActive() {
        return this.active;
    }

    public void close() {
        this.active = false;
    }

    public void invalidate() {
        this.close();
        this.clearAttributes();
    }

    protected void checkActive() throws IllegalStateException {
        Assert.state((boolean)this.active, (String)"Request is not active anymore");
    }

    public Object getAttribute(String name) {
        this.checkActive();
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkActive();
        return Collections.enumeration(new LinkedHashSet<String>(this.attributes.keySet()));
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(@Nullable String characterEncoding) {
        this.characterEncoding = characterEncoding;
        this.updateContentTypeHeader();
    }

    private void updateContentTypeHeader() {
        if (StringUtils.hasLength((String)this.contentType)) {
            StringBuilder sb = new StringBuilder(this.contentType);
            if (!this.contentType.toLowerCase().contains(CHARSET_PREFIX) && StringUtils.hasLength((String)this.characterEncoding)) {
                sb.append(";").append(CHARSET_PREFIX).append(this.characterEncoding);
            }
            this.doAddHeaderValue("Content-Type", sb.toString(), true);
        }
    }

    public void setContent(@Nullable byte[] content) {
        this.content = content;
    }

    @Nullable
    public byte[] getContentAsByteArray() {
        return this.content;
    }

    @Nullable
    public String getContentAsString() throws IllegalStateException, UnsupportedEncodingException {
        Assert.state((this.characterEncoding != null ? 1 : 0) != 0, (String)"Cannot get content as a String for a null character encoding. Consider setting the characterEncoding in the request.");
        if (this.content == null) {
            return null;
        }
        return new String(this.content, this.characterEncoding);
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public void setContentType(@Nullable String contentType) {
        this.contentType = contentType;
        if (contentType != null) {
            block4: {
                try {
                    MediaType mediaType = MediaType.parseMediaType((String)contentType);
                    if (mediaType.getCharset() != null) {
                        this.characterEncoding = mediaType.getCharset().name();
                    }
                }
                catch (IllegalArgumentException ex) {
                    int charsetIndex = contentType.toLowerCase().indexOf(CHARSET_PREFIX);
                    if (charsetIndex == -1) break block4;
                    this.characterEncoding = contentType.substring(charsetIndex + CHARSET_PREFIX.length());
                }
            }
            this.updateContentTypeHeader();
        }
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        if (this.content != null) {
            return new DelegatingServletInputStream(new ByteArrayInputStream(this.content));
        }
        return EMPTY_SERVLET_INPUT_STREAM;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String ... values) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.parameters.put(name, values);
    }

    public void setParameters(Map<String, ?> params) {
        Assert.notNull(params, (String)"Parameter map must not be null");
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                this.setParameter(key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.setParameter(key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void addParameter(String name, @Nullable String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String ... values) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        String[] oldArr = this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public void addParameters(Map<String, ?> params) {
        Assert.notNull(params, (String)"Parameter map must not be null");
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                this.addParameter(key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.addParameter(key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void removeParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.parameters.remove(name);
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    @Nullable
    public String getParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        String[] arr = this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        String host = this.getHeader("Host");
        if (host != null) {
            if ((host = host.trim()).startsWith("[")) {
                host = host.substring(1, host.indexOf(93));
            } else if (host.contains(":")) {
                host = host.substring(0, host.indexOf(58));
            }
            return host;
        }
        return this.serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        int idx;
        String host = this.getHeader("Host");
        if (host != null && (idx = (host = host.trim()).startsWith("[") ? host.indexOf(58, host.indexOf(93)) : host.indexOf(58)) != -1) {
            return Integer.parseInt(host.substring(idx + 1));
        }
        return this.serverPort;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return EMPTY_BUFFERED_READER;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, @Nullable Object value) {
        this.checkActive();
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.checkActive();
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        this.attributes.remove(name);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void addPreferredLocale(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        this.locales.add(0, locale);
        this.updateAcceptLanguageHeader();
    }

    public void setPreferredLocales(List<Locale> locales) {
        Assert.notEmpty(locales, (String)"Locale list must not be empty");
        this.locales.clear();
        this.locales.addAll(locales);
        this.updateAcceptLanguageHeader();
    }

    private void updateAcceptLanguageHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAcceptLanguageAsLocales(this.locales);
        this.doAddHeaderValue("Accept-Language", headers.getFirst("Accept-Language"), true);
    }

    public Locale getLocale() {
        return this.locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure || HTTPS.equalsIgnoreCase(this.scheme);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher(path);
    }

    @Deprecated
    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this, null);
    }

    public AsyncContext startAsync(ServletRequest request, @Nullable ServletResponse response) {
        Assert.state((boolean)this.asyncSupported, (String)"Async not supported");
        this.asyncStarted = true;
        this.asyncContext = new MockAsyncContext(request, response);
        return this.asyncContext;
    }

    public void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted = asyncStarted;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncContext(@Nullable MockAsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    @Nullable
    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setAuthType(@Nullable String authType) {
        this.authType = authType;
    }

    @Nullable
    public String getAuthType() {
        return this.authType;
    }

    public void setCookies(Cookie ... cookies) {
        this.cookies = ObjectUtils.isEmpty((Object[])cookies) ? null : cookies;
        this.headers.remove("Cookie");
        if (this.cookies != null) {
            Arrays.stream(this.cookies).map(c -> c.getName() + '=' + (c.getValue() == null ? "" : c.getValue())).forEach(value -> this.doAddHeaderValue("Cookie", value, false));
        }
    }

    @Nullable
    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addHeader(String name, Object value) {
        if ("Content-Type".equalsIgnoreCase(name) && !this.headers.containsKey("Content-Type")) {
            this.setContentType(value.toString());
        } else if ("Accept-Language".equalsIgnoreCase(name) && !this.headers.containsKey("Accept-Language")) {
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.add("Accept-Language", value.toString());
                this.setPreferredLocales(headers.getAcceptLanguageAsLocales());
            }
            catch (IllegalArgumentException ex) {
                this.doAddHeaderValue(name, value, true);
            }
        } else {
            this.doAddHeaderValue(name, value, false);
        }
    }

    private void doAddHeaderValue(String name, @Nullable Object value, boolean replace) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Assert.notNull((Object)value, (String)"Header value must not be null");
        if (header == null || replace) {
            header = new HeaderValueHolder();
            this.headers.put(name, header);
        }
        if (value instanceof Collection) {
            header.addValues((Collection)value);
        } else if (value.getClass().isArray()) {
            header.addValueArray(value);
        } else {
            header.addValue(value);
        }
    }

    public long getDateHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return this.parseDateHeader(name, (String)value);
        }
        if (value != null) {
            throw new IllegalArgumentException("Value for header '" + name + "' is not a Date, Number, or String: " + value);
        }
        return -1L;
    }

    private long parseDateHeader(String name, String value) {
        for (String dateFormat : DATE_FORMATS) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
            simpleDateFormat.setTimeZone(GMT);
            try {
                return simpleDateFormat.parse(value).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse date value '" + value + "' for '" + name + "' header");
    }

    @Nullable
    public String getHeader(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return header != null ? header.getStringValue() : null;
    }

    public Enumeration<String> getHeaders(String name) {
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        return Collections.enumeration(header != null ? header.getStringValues() : new LinkedList());
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        Object value;
        HeaderValueHolder header = HeaderValueHolder.getByName(this.headers, name);
        Object object = value = header != null ? header.getValue() : null;
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value != null) {
            throw new NumberFormatException("Value for header '" + name + "' is not a Number: " + value);
        }
        return -1;
    }

    public void setMethod(@Nullable String method) {
        this.method = method;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public void setPathInfo(@Nullable String pathInfo) {
        this.pathInfo = pathInfo;
    }

    @Nullable
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Nullable
    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setQueryString(@Nullable String queryString) {
        this.queryString = queryString;
    }

    @Nullable
    public String getQueryString() {
        return this.queryString;
    }

    public void setRemoteUser(@Nullable String remoteUser) {
        this.remoteUser = remoteUser;
    }

    @Nullable
    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role) || this.servletContext instanceof MockServletContext && ((MockServletContext)this.servletContext).getDeclaredRoles().contains(role);
    }

    public void setUserPrincipal(@Nullable Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    @Nullable
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setRequestedSessionId(@Nullable String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    @Nullable
    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public void setRequestURI(@Nullable String requestURI) {
        this.requestURI = requestURI;
    }

    @Nullable
    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        String scheme = this.getScheme();
        String server = this.getServerName();
        int port = this.getServerPort();
        String uri = this.getRequestURI();
        StringBuffer url = new StringBuffer(scheme).append("://").append(server);
        if (port > 0 && ("http".equalsIgnoreCase(scheme) && port != 80 || HTTPS.equalsIgnoreCase(scheme) && port != 443)) {
            url.append(':').append(port);
        }
        if (StringUtils.hasText((String)uri)) {
            url.append(uri);
        }
        return url;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setSession(HttpSession session) {
        this.session = session;
        if (session instanceof MockHttpSession) {
            MockHttpSession mockSession = (MockHttpSession)session;
            mockSession.access();
        }
    }

    @Nullable
    public HttpSession getSession(boolean create) {
        this.checkActive();
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isInvalid()) {
            this.session = null;
        }
        if (this.session == null && create) {
            this.session = new MockHttpSession(this.servletContext);
        }
        return this.session;
    }

    @Nullable
    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        Assert.isTrue((this.session != null ? 1 : 0) != 0, (String)"The request does not have a session");
        if (this.session instanceof MockHttpSession) {
            return ((MockHttpSession)this.session).changeSessionId();
        }
        return this.session.getId();
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        this.userPrincipal = null;
        this.remoteUser = null;
        this.authType = null;
    }

    public void addPart(Part part) {
        this.parts.add((Object)part.getName(), (Object)part);
    }

    @Nullable
    public Part getPart(String name) throws IOException, ServletException {
        return (Part)this.parts.getFirst((Object)name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LinkedList<Part> result = new LinkedList<Part>();
        for (List list : this.parts.values()) {
            result.addAll(list);
        }
        return result;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }
}

