/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Collections;
import java.util.List;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

public class HeaderContentNegotiationStrategy
implements ContentNegotiationStrategy {
    private static final String ACCEPT_HEADER = "Accept";

    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
        String acceptHeader = webRequest.getHeader(ACCEPT_HEADER);
        try {
            if (StringUtils.hasText((String)acceptHeader)) {
                List<MediaType> mediaTypes = MediaType.parseMediaTypes(acceptHeader);
                MediaType.sortBySpecificityAndQuality(mediaTypes);
                return mediaTypes;
            }
        }
        catch (InvalidMediaTypeException ex) {
            throw new HttpMediaTypeNotAcceptableException("Could not parse accept header [" + acceptHeader + "]: " + ex.getMessage());
        }
        return Collections.emptyList();
    }
}

