/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.remoting.EndpointConfigFactory;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.Services;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.Option;
import org.xnio.OptionMap;

public class DomainServerCommunicationServices
implements ServiceActivator,
Serializable {
    private static final OptionMap DEFAULTS = OptionMap.create((Option)RemotingOptions.RECEIVE_WINDOW_SIZE, (Object)32768);
    private static final long serialVersionUID = 1593964083902839384L;
    private static volatile int initialOperationID;
    private final ModelNode endpointConfig;
    private final InetSocketAddress managementSocket;
    private final String serverName;
    private final String serverProcessName;
    private final byte[] authKey;
    private final boolean managementSubsystemEndpoint;

    DomainServerCommunicationServices(ModelNode endpointConfig, InetSocketAddress managementSocket, String serverName, String serverProcessName, byte[] authKey, boolean managementSubsystemEndpoint) {
        this.endpointConfig = endpointConfig;
        this.managementSocket = managementSocket;
        this.serverName = serverName;
        this.serverProcessName = serverProcessName;
        this.authKey = authKey;
        this.managementSubsystemEndpoint = managementSubsystemEndpoint;
    }

    static void updateOperationID(int operationID) {
        initialOperationID = operationID;
    }

    public void activate(ServiceActivatorContext serviceActivatorContext) throws ServiceRegistryException {
        ServiceTarget serviceTarget = serviceActivatorContext.getServiceTarget();
        ServiceName endpointName = this.managementSubsystemEndpoint ? RemotingServices.SUBSYSTEM_ENDPOINT : ManagementRemotingServices.MANAGEMENT_ENDPOINT;
        EndpointService.EndpointType endpointType = this.managementSubsystemEndpoint ? EndpointService.EndpointType.SUBSYSTEM : EndpointService.EndpointType.MANAGEMENT;
        try {
            OptionMap options = EndpointConfigFactory.create((ExpressionResolver)ExpressionResolver.DEFAULT, (ModelNode)this.endpointConfig, (OptionMap)DEFAULTS);
            ManagementRemotingServices.installRemotingManagementEndpoint((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null), (EndpointService.EndpointType)endpointType, (OptionMap)options, null, null);
            int port = this.managementSocket.getPort();
            String host = NetworkUtils.canonize((String)this.managementSocket.getAddress().getHostAddress());
            HostControllerConnectionService service = new HostControllerConnectionService(host, port, this.serverName, this.serverProcessName, this.authKey, initialOperationID, this.managementSubsystemEndpoint);
            Services.addServerExecutorDependency(serviceTarget.addService(HostControllerConnectionService.SERVICE_NAME, (Service)service), service.getExecutorInjector(), false).addDependency(endpointName, Endpoint.class, service.getEndpointInjector()).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, service.getProcessStateServiceInjectedValue()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (OperationFailedException e) {
            throw new ServiceRegistryException((Throwable)e);
        }
    }

    public static ServiceActivator create(ModelNode endpointConfig, InetSocketAddress managementSocket, String serverName, String serverProcessName, byte[] authKey, boolean managementSubsystemEndpoint) {
        return new DomainServerCommunicationServices(endpointConfig, managementSocket, serverName, serverProcessName, authKey, managementSubsystemEndpoint);
    }

    public static interface OperationIDUpdater {
        public void updateOperationID(int var1);
    }
}

