/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.store.BlobStore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class StreamSources {
    private StreamSources() {
    }

    public static InputStreamSource forString(String string, Charset charset) {
        return new StringInputStreamSource(string, charset);
    }

    public static InputStreamSource forBytes(byte[] bytes) {
        return new ByteArrayInputStreamSource(bytes);
    }

    public static InputStreamSource forBlobStoreItem(BlobStore blobStore, String key) {
        return () -> blobStore.getStream(key).orElseThrow(() -> new NotFoundException("Not found in blob store: " + key));
    }

    public static InputStreamSource empty() {
        return StreamSources.forBytes(new byte[0]);
    }

    public static class ByteArrayInputStreamSource
    implements InputStreamSource {
        private final byte[] bytes;

        public ByteArrayInputStreamSource(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public InputStream getStream() {
            return this.bytes == null ? null : new ByteArrayInputStream(this.bytes);
        }
    }

    public static class StringInputStreamSource
    extends ByteArrayInputStreamSource {
        public StringInputStreamSource(String string, Charset charset) {
            super(Strings.bytesFromString(string, charset));
        }
    }
}

