/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.store.RequestJournalStore;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Stream;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class InMemoryRequestJournalStore
implements RequestJournalStore {
    private final Deque<UUID> deque = new ConcurrentLinkedDeque<UUID>();
    private final Map<UUID, ServeEvent> serveEvents = new ConcurrentHashMap<UUID, ServeEvent>();

    @Override
    public void add(ServeEvent event) {
        this.serveEvents.put(event.getId(), event);
        this.deque.addFirst(event.getId());
    }

    @Override
    public Stream<ServeEvent> getAll() {
        return this.deque.stream().map(this.serveEvents::get);
    }

    @Override
    public void removeLast() {
        UUID id = this.deque.pollLast();
        if (id != null) {
            this.serveEvents.remove(id);
        }
    }

    @Override
    public Stream<UUID> getAllKeys() {
        return this.getAll().map(ServeEvent::getId);
    }

    @Override
    public Optional<ServeEvent> get(UUID id) {
        return Optional.ofNullable(this.serveEvents.get(id));
    }

    @Override
    public void put(UUID id, ServeEvent event) {
        if (this.deque.contains(id)) {
            this.serveEvents.put(id, event);
        }
    }

    @Override
    public void remove(UUID id) {
        this.deque.stream().filter(eventId -> eventId.equals(id)).forEach(this.deque::remove);
        this.serveEvents.remove(id);
    }

    @Override
    public void clear() {
        this.deque.clear();
        this.serveEvents.clear();
    }
}

