/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.server;

import java.util.function.Consumer;
import wiremock.org.eclipse.jetty.http2.HTTP2Channel;
import wiremock.org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import wiremock.org.eclipse.jetty.http2.IStream;
import wiremock.org.eclipse.jetty.http2.frames.DataFrame;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ServerHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(ServerHTTP2StreamEndPoint.class);

    public ServerHTTP2StreamEndPoint(IStream stream) {
        super(stream);
    }

    @Override
    public Runnable onData(DataFrame frame, Callback callback) {
        this.offerData(frame, callback);
        return null;
    }

    @Override
    public Runnable onTrailer(HeadersFrame frame) {
        return null;
    }

    @Override
    public boolean onTimeout(Throwable failure, Consumer<Runnable> consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}: {}", (Object)this, (Object)failure);
        }
        boolean result = true;
        Connection connection = this.getConnection();
        if (connection != null) {
            result = connection.onIdleExpired();
        }
        if (result) {
            this.offerFailure(failure);
            consumer.accept(() -> this.close(failure));
        }
        return result;
    }

    @Override
    public Runnable onFailure(Throwable failure, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failure on {}: {}", (Object)this, (Object)failure);
        }
        this.offerFailure(failure);
        this.close(failure);
        return callback::succeeded;
    }

    @Override
    public boolean isIdle() {
        return false;
    }
}

