/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.RemoteIdentification;
import com.sshtools.common.automate.RemoteIdentificationRule;
import com.sshtools.common.automate.UnsupportedRuleException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutomationConfiguration {
    private HashMap remoteIdentifications = new HashMap();

    public AutomationConfiguration(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)new AutomationConfigurationSAXHandler());
    }

    public Map getRemoteIdentifications() {
        return this.remoteIdentifications;
    }

    public static void main(String[] stringArray) {
    }

    private class AutomationConfigurationSAXHandler
    extends DefaultHandler {
        private String AUTOMATION_ELEMENT = "Automation";
        private String REMOTEID_ELEMENT = "RemoteIdentification";
        private String AUTHORIZEDKEYSFORMAT_ELEMENT = "AuthorizedKeysFormat";
        private String RULE_ELEMENT = "Rule";
        private String STARTSWITH_ATTRIBUTE = "startsWith";
        private String CONTAINS_ATTRIBUTE = "contains";
        private String DEFAULTNAME_ATTRIBUTE = "defaultName";
        private String NAME_ATTRIBUTE = "name";
        private String IMPLEMENTATION_ATTRIBUTE = "implementationClass";
        private String PRIORITY_ATTRIBUTE = "priority";
        private String DEFAULTPATH_ATTRIBUTE = "defaultPath";
        private String currentElement = null;
        private RemoteIdentification currentRID = null;

        private AutomationConfigurationSAXHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.currentElement == null) {
                if (!string3.equals(this.AUTOMATION_ELEMENT)) {
                    throw new SAXException("Unexpected root element <" + string3 + ">");
                }
            } else if (this.currentElement.equals(this.AUTOMATION_ELEMENT)) {
                if (!string3.equals(this.REMOTEID_ELEMENT)) throw new SAXException("Unexpected element <" + string3 + ">");
                String string4 = attributes.getValue(this.DEFAULTNAME_ATTRIBUTE);
                if (string4 == null) {
                    throw new SAXException(this.DEFAULTNAME_ATTRIBUTE + " attribute must be specified");
                }
                this.currentRID = new RemoteIdentification(string4);
            } else {
                if (!this.currentElement.equals(this.REMOTEID_ELEMENT)) throw new SAXException("Unexpected element <" + string3 + ">");
                if (string3.equals(this.RULE_ELEMENT)) {
                    String string5 = attributes.getValue(this.STARTSWITH_ATTRIBUTE);
                    String string6 = attributes.getValue(this.CONTAINS_ATTRIBUTE);
                    String string7 = attributes.getValue(this.NAME_ATTRIBUTE);
                    String string8 = attributes.getValue(this.PRIORITY_ATTRIBUTE);
                    try {
                        RemoteIdentificationRule remoteIdentificationRule = new RemoteIdentificationRule();
                        if (string5 != null) {
                            remoteIdentificationRule.addExpression(this.STARTSWITH_ATTRIBUTE, string5);
                        }
                        if (string6 != null) {
                            remoteIdentificationRule.addExpression(this.CONTAINS_ATTRIBUTE, string6);
                        }
                        if (string7 != null) {
                            remoteIdentificationRule.setName(string7);
                        }
                        try {
                            if (string8 != null) {
                                remoteIdentificationRule.setPriority(Integer.parseInt(string8));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SAXException("Failed to parse priority value! value=" + string8);
                        }
                        this.currentRID.addRule(remoteIdentificationRule);
                    }
                    catch (UnsupportedRuleException unsupportedRuleException) {
                        throw new SAXException(unsupportedRuleException.getMessage());
                    }
                }
                if (!string3.equals(this.AUTHORIZEDKEYSFORMAT_ELEMENT)) throw new SAXException("Unexpected element <" + string3 + ">");
                String string9 = attributes.getValue(this.IMPLEMENTATION_ATTRIBUTE);
                String string10 = attributes.getValue(this.DEFAULTPATH_ATTRIBUTE);
                if (string9 == null) {
                    throw new SAXException(this.IMPLEMENTATION_ATTRIBUTE + " attribute is required");
                }
                try {
                    this.currentRID.setAuthorizedKeysFormat(Class.forName(string9));
                    this.currentRID.setAuthorizedKeysDefaultPath(string10);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new SAXException(classNotFoundException.getMessage());
                }
            }
            this.currentElement = string3;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentElement != null) {
                if (!this.currentElement.equals(string3)) {
                    throw new SAXException("Unexpected end element found <" + string3 + ">");
                }
                if (this.currentElement.equals(this.REMOTEID_ELEMENT)) {
                    if (this.currentRID.getRules().size() <= 0) {
                        throw new SAXException("<" + this.REMOTEID_ELEMENT + "> " + " requires at least one child <" + this.RULE_ELEMENT + "> element!");
                    }
                    AutomationConfiguration.this.remoteIdentifications.put(this.currentRID.getDefaultName(), this.currentRID);
                    this.currentElement = this.AUTOMATION_ELEMENT;
                } else if (this.currentElement.equals(this.RULE_ELEMENT)) {
                    this.currentElement = this.REMOTEID_ELEMENT;
                } else if (this.currentElement.equals(this.AUTHORIZEDKEYSFORMAT_ELEMENT)) {
                    this.currentElement = this.REMOTEID_ELEMENT;
                } else if (this.currentElement.equals(this.AUTOMATION_ELEMENT)) {
                    this.currentElement = null;
                } else {
                    throw new SAXException("Unexpected end element <" + string3 + ">");
                }
            }
        }
    }
}

