/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.configuration;

import com.sshtools.common.automate.AutomationConfiguration;
import com.sshtools.common.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlConfigurationContext
implements ConfigurationContext {
    private static Log log = LogFactory.getLog((Class)XmlConfigurationContext.class);
    HashMap configurations = new HashMap();
    String apiResource = "sshtools.xml";
    String automationResource = "automation.xml";
    private boolean failOnError = false;

    public void setAPIConfigurationResource(String string) {
        this.apiResource = string;
    }

    public void setAutomationConfigurationResource(String string) {
        this.automationResource = string;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void initialize() throws ConfigurationException {
        Object object;
        if (this.apiResource != null) {
            try {
                object = new SshAPIConfiguration(ConfigurationLoader.loadFile((String)this.apiResource));
                this.configurations.put(com.sshtools.j2ssh.configuration.SshAPIConfiguration.class, object);
            }
            catch (Exception exception) {
                if (this.failOnError) {
                    throw new ConfigurationException(exception.getMessage());
                }
                log.info((Object)(this.apiResource + " could not be found: " + exception.getMessage()));
            }
        }
        if (this.automationResource != null) {
            try {
                object = new AutomationConfiguration(ConfigurationLoader.loadFile((String)this.automationResource));
                this.configurations.put(AutomationConfiguration.class, object);
            }
            catch (Exception exception) {
                if (this.failOnError) {
                    throw new ConfigurationException(exception.getMessage());
                }
                log.info((Object)(this.automationResource + " could not be found: " + exception.getMessage()));
            }
        }
    }

    public boolean isConfigurationAvailable(Class clazz) {
        return this.configurations.containsKey(clazz);
    }

    public Object getConfiguration(Class clazz) throws ConfigurationException {
        if (this.configurations.containsKey(clazz)) {
            return this.configurations.get(clazz);
        }
        throw new ConfigurationException(clazz.getName() + " configuration not available");
    }
}

